/*!
 * jQuery throttle / debounce - v1.1 - 3/7/2010
 * http://benalman.com/projects/jquery-throttle-debounce-plugin/
 * 
 * Copyright (c) 2010 "Cowboy" Ben Alman
 * Dual licensed under the MIT and GPL licenses.
 * http://benalman.com/about/license/
 */

// Script: jQuery throttle / debounce: Sometimes, less is more!
//
// *Version: 1.1, Last updated: 3/7/2010*
// 
// Project Home - http://benalman.com/projects/jquery-throttle-debounce-plugin/
// GitHub       - http://github.com/cowboy/jquery-throttle-debounce/
// Source       - http://github.com/cowboy/jquery-throttle-debounce/raw/master/jquery.ba-throttle-debounce.js
// (Minified)   - http://github.com/cowboy/jquery-throttle-debounce/raw/master/jquery.ba-throttle-debounce.min.js (0.7kb)
// 
// About: License
// 
// Copyright (c) 2010 "Cowboy" Ben Alman,
// Dual licensed under the MIT and GPL licenses.
// http://benalman.com/about/license/
// 
// About: Examples
// 
// These working examples, complete with fully commented code, illustrate a few
// ways in which this plugin can be used.
// 
// Throttle - http://benalman.com/code/projects/jquery-throttle-debounce/examples/throttle/
// Debounce - http://benalman.com/code/projects/jquery-throttle-debounce/examples/debounce/
// 
// About: Support and Testing
// 
// Information about what version or versions of jQuery this plugin has been
// tested with, what browsers it has been tested in, and where the unit tests
// reside (so you can test it yourself).
// 
// jQuery Versions - none, 1.3.2, 1.4.2
// Browsers Tested - Internet Explorer 6-8, Firefox 2-3.6, Safari 3-4, Chrome 4-5, Opera 9.6-10.1.
// Unit Tests      - http://benalman.com/code/projects/jquery-throttle-debounce/unit/
// 
// About: Release History
// 
// 1.1 - (3/7/2010) Fixed a bug in <jQuery.throttle> where trailing callbacks
//       executed later than they should. Reworked a fair amount of internal
//       logic as well.
// 1.0 - (3/6/2010) Initial release as a stand-alone project. Migrated over
//       from jquery-misc repo v0.4 to jquery-throttle repo v1.0, added the
//       no_trailing throttle parameter and debounce functionality.
// 
// Topic: Note for non-jQuery users
// 
// jQuery isn't actually required for this plugin, because nothing internal
// uses any jQuery methods or properties. jQuery is just used as a namespace
// under which these methods can exist.
// 
// Since jQuery isn't actually required for this plugin, if jQuery doesn't exist
// when this plugin is loaded, the method described below will be created in
// the `Cowboy` namespace. Usage will be exactly the same, but instead of
// $.method() or jQuery.method(), you'll need to use Cowboy.method().

(function(window,undefined){
  '$:nomunge'; // Used by YUI compressor.
  
  // Since jQuery really isn't required for this plugin, use `jQuery` as the
  // namespace only if it already exists, otherwise use the `Cowboy` namespace,
  // creating it if necessary.
  var $ = window.jQuery || window.Cowboy || ( window.Cowboy = {} ),
    
    // Internal method reference.
    jq_throttle;
  
  // Method: jQuery.throttle
  // 
  // Throttle execution of a function. Especially useful for rate limiting
  // execution of handlers on events like resize and scroll. If you want to
  // rate-limit execution of a function to a single time, see the
  // <jQuery.debounce> method.
  // 
  // In this visualization, | is a throttled-function call and X is the actual
  // callback execution:
  // 
  // > Throttled with `no_trailing` specified as false or unspecified:
  // > ||||||||||||||||||||||||| (pause) |||||||||||||||||||||||||
  // > X    X    X    X    X    X        X    X    X    X    X    X
  // > 
  // > Throttled with `no_trailing` specified as true:
  // > ||||||||||||||||||||||||| (pause) |||||||||||||||||||||||||
  // > X    X    X    X    X             X    X    X    X    X
  // 
  // Usage:
  // 
  // > var throttled = jQuery.throttle( delay, [ no_trailing, ] callback );
  // > 
  // > jQuery('selector').bind( 'someevent', throttled );
  // > jQuery('selector').unbind( 'someevent', throttled );
  // 
  // This also works in jQuery 1.4+:
  // 
  // > jQuery('selector').bind( 'someevent', jQuery.throttle( delay, [ no_trailing, ] callback ) );
  // > jQuery('selector').unbind( 'someevent', callback );
  // 
  // Arguments:
  // 
  //  delay - (Number) A zero-or-greater delay in milliseconds. For event
  //    callbacks, values around 100 or 250 (or even higher) are most useful.
  //  no_trailing - (Boolean) Optional, defaults to false. If no_trailing is
  //    true, callback will only execute every `delay` milliseconds while the
  //    throttled-function is being called. If no_trailing is false or
  //    unspecified, callback will be executed one final time after the last
  //    throttled-function call. (After the throttled-function has not been
  //    called for `delay` milliseconds, the internal counter is reset)
  //  callback - (Function) A function to be executed after delay milliseconds.
  //    The `this` context and all arguments are passed through, as-is, to
  //    `callback` when the throttled-function is executed.
  // 
  // Returns:
  // 
  //  (Function) A new, throttled, function.
  
  $.throttle = jq_throttle = function( delay, no_trailing, callback, debounce_mode ) {
    // After wrapper has stopped being called, this timeout ensures that
    // `callback` is executed at the proper times in `throttle` and `end`
    // debounce modes.
    var timeout_id,
      
      // Keep track of the last time `callback` was executed.
      last_exec = 0;
    
    // `no_trailing` defaults to falsy.
    if ( typeof no_trailing !== 'boolean' ) {
      debounce_mode = callback;
      callback = no_trailing;
      no_trailing = undefined;
    }
    
    // The `wrapper` function encapsulates all of the throttling / debouncing
    // functionality and when executed will limit the rate at which `callback`
    // is executed.
    function wrapper() {
      var that = this,
        elapsed = +new Date() - last_exec,
        args = arguments;
      
      // Execute `callback` and update the `last_exec` timestamp.
      function exec() {
        last_exec = +new Date();
        callback.apply( that, args );
      };
      
      // If `debounce_mode` is true (at_begin) this is used to clear the flag
      // to allow future `callback` executions.
      function clear() {
        timeout_id = undefined;
      };
      
      if ( debounce_mode && !timeout_id ) {
        // Since `wrapper` is being called for the first time and
        // `debounce_mode` is true (at_begin), execute `callback`.
        exec();
      }
      
      // Clear any existing timeout.
      timeout_id && clearTimeout( timeout_id );
      
      if ( debounce_mode === undefined && elapsed > delay ) {
        // In throttle mode, if `delay` time has been exceeded, execute
        // `callback`.
        exec();
        
      } else if ( no_trailing !== true ) {
        // In trailing throttle mode, since `delay` time has not been
        // exceeded, schedule `callback` to execute `delay` ms after most
        // recent execution.
        // 
        // If `debounce_mode` is true (at_begin), schedule `clear` to execute
        // after `delay` ms.
        // 
        // If `debounce_mode` is false (at end), schedule `callback` to
        // execute after `delay` ms.
        timeout_id = setTimeout( debounce_mode ? clear : exec, debounce_mode === undefined ? delay - elapsed : delay );
      }
    };
    
    // Set the guid of `wrapper` function to the same of original callback, so
    // it can be removed in jQuery 1.4+ .unbind or .die by using the original
    // callback as a reference.
    if ( $.guid ) {
      wrapper.guid = callback.guid = callback.guid || $.guid++;
    }
    
    // Return the wrapper function.
    return wrapper;
  };
  
  // Method: jQuery.debounce
  // 
  // Debounce execution of a function. Debouncing, unlike throttling,
  // guarantees that a function is only executed a single time, either at the
  // very beginning of a series of calls, or at the very end. If you want to
  // simply rate-limit execution of a function, see the <jQuery.throttle>
  // method.
  // 
  // In this visualization, | is a debounced-function call and X is the actual
  // callback execution:
  // 
  // > Debounced with `at_begin` specified as false or unspecified:
  // > ||||||||||||||||||||||||| (pause) |||||||||||||||||||||||||
  // >                          X                                 X
  // > 
  // > Debounced with `at_begin` specified as true:
  // > ||||||||||||||||||||||||| (pause) |||||||||||||||||||||||||
  // > X                                 X
  // 
  // Usage:
  // 
  // > var debounced = jQuery.debounce( delay, [ at_begin, ] callback );
  // > 
  // > jQuery('selector').bind( 'someevent', debounced );
  // > jQuery('selector').unbind( 'someevent', debounced );
  // 
  // This also works in jQuery 1.4+:
  // 
  // > jQuery('selector').bind( 'someevent', jQuery.debounce( delay, [ at_begin, ] callback ) );
  // > jQuery('selector').unbind( 'someevent', callback );
  // 
  // Arguments:
  // 
  //  delay - (Number) A zero-or-greater delay in milliseconds. For event
  //    callbacks, values around 100 or 250 (or even higher) are most useful.
  //  at_begin - (Boolean) Optional, defaults to false. If at_begin is false or
  //    unspecified, callback will only be executed `delay` milliseconds after
  //    the last debounced-function call. If at_begin is true, callback will be
  //    executed only at the first debounced-function call. (After the
  //    throttled-function has not been called for `delay` milliseconds, the
  //    internal counter is reset)
  //  callback - (Function) A function to be executed after delay milliseconds.
  //    The `this` context and all arguments are passed through, as-is, to
  //    `callback` when the debounced-function is executed.
  // 
  // Returns:
  // 
  //  (Function) A new, debounced, function.
  
  $.debounce = function( delay, at_begin, callback ) {
    return callback === undefined
      ? jq_throttle( delay, at_begin, false )
      : jq_throttle( delay, callback, at_begin !== false );
  };
  
})(this);

/*
 * @build  : 20-07-2013
 * @author : Ram swaroop
 * @site   : Compzets.com
 */
(function($){
      
    // defines various easing effects
    $.easing['jswing'] = $.easing['swing'];
    $.extend( $.easing,
    {
            def: 'easeOutQuad',
            swing: function (x, t, b, c, d) {
                    return $.easing[$.easing.def](x, t, b, c, d);
            },
            easeInQuad: function (x, t, b, c, d) {
                    return c*(t/=d)*t + b;
            },
            easeOutQuad: function (x, t, b, c, d) {
                    return -c *(t/=d)*(t-2) + b;
            },
            easeInOutQuad: function (x, t, b, c, d) {
                    if ((t/=d/2) < 1) return c/2*t*t + b;
                    return -c/2 * ((--t)*(t-2) - 1) + b;
            },
            easeInCubic: function (x, t, b, c, d) {
                    return c*(t/=d)*t*t + b;
            },
            easeOutCubic: function (x, t, b, c, d) {
                    return c*((t=t/d-1)*t*t + 1) + b;
            },
            easeInOutCubic: function (x, t, b, c, d) {
                    if ((t/=d/2) < 1) return c/2*t*t*t + b;
                    return c/2*((t-=2)*t*t + 2) + b;
            },
            easeInQuart: function (x, t, b, c, d) {
                    return c*(t/=d)*t*t*t + b;
            },
            easeOutQuart: function (x, t, b, c, d) {
                    return -c * ((t=t/d-1)*t*t*t - 1) + b;
            },
            easeInOutQuart: function (x, t, b, c, d) {
                    if ((t/=d/2) < 1) return c/2*t*t*t*t + b;
                    return -c/2 * ((t-=2)*t*t*t - 2) + b;
            },
            easeInQuint: function (x, t, b, c, d) {
                    return c*(t/=d)*t*t*t*t + b;
            },
            easeOutQuint: function (x, t, b, c, d) {
                    return c*((t=t/d-1)*t*t*t*t + 1) + b;
            },
            easeInOutQuint: function (x, t, b, c, d) {
                    if ((t/=d/2) < 1) return c/2*t*t*t*t*t + b;
                    return c/2*((t-=2)*t*t*t*t + 2) + b;
            },
            easeInSine: function (x, t, b, c, d) {
                    return -c * Math.cos(t/d * (Math.PI/2)) + c + b;
            },
            easeOutSine: function (x, t, b, c, d) {
                    return c * Math.sin(t/d * (Math.PI/2)) + b;
            },
            easeInOutSine: function (x, t, b, c, d) {
                    return -c/2 * (Math.cos(Math.PI*t/d) - 1) + b;
            },
            easeInExpo: function (x, t, b, c, d) {
                    return (t==0) ? b : c * Math.pow(2, 10 * (t/d - 1)) + b;
            },
            easeOutExpo: function (x, t, b, c, d) {
                    return (t==d) ? b+c : c * (-Math.pow(2, -10 * t/d) + 1) + b;
            },
            easeInOutExpo: function (x, t, b, c, d) {
                    if (t==0) return b;
                    if (t==d) return b+c;
                    if ((t/=d/2) < 1) return c/2 * Math.pow(2, 10 * (t - 1)) + b;
                    return c/2 * (-Math.pow(2, -10 * --t) + 2) + b;
            },
            easeInCirc: function (x, t, b, c, d) {
                    return -c * (Math.sqrt(1 - (t/=d)*t) - 1) + b;
            },
            easeOutCirc: function (x, t, b, c, d) {
                    return c * Math.sqrt(1 - (t=t/d-1)*t) + b;
            },
            easeInOutCirc: function (x, t, b, c, d) {
                    if ((t/=d/2) < 1) return -c/2 * (Math.sqrt(1 - t*t) - 1) + b;
                    return c/2 * (Math.sqrt(1 - (t-=2)*t) + 1) + b;
            },
            easeInElastic: function (x, t, b, c, d) {
                    var s=1.70158;var p=0;var a=c;
                    if (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;
                    if (a < Math.abs(c)) { a=c; var s=p/4; }
                    else var s = p/(2*Math.PI) * Math.asin (c/a);
                    return -(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )) + b;
            },
            easeOutElastic: function (x, t, b, c, d) {
                    var s=1.70158;var p=0;var a=c;
                    if (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;
                    if (a < Math.abs(c)) { a=c; var s=p/4; }
                    else var s = p/(2*Math.PI) * Math.asin (c/a);
                    return a*Math.pow(2,-10*t) * Math.sin( (t*d-s)*(2*Math.PI)/p ) + c + b;
            },
            easeInOutElastic: function (x, t, b, c, d) {
                    var s=1.70158;var p=0;var a=c;
                    if (t==0) return b;  if ((t/=d/2)==2) return b+c;  if (!p) p=d*(.3*1.5);
                    if (a < Math.abs(c)) { a=c; var s=p/4; }
                    else var s = p/(2*Math.PI) * Math.asin (c/a);
                    if (t < 1) return -.5*(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )) + b;
                    return a*Math.pow(2,-10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )*.5 + c + b;
            },
            easeInBack: function (x, t, b, c, d, s) {
                    if (s == undefined) s = 1.70158;
                    return c*(t/=d)*t*((s+1)*t - s) + b;
            },
            easeOutBack: function (x, t, b, c, d, s) {
                    if (s == undefined) s = 1.70158;
                    return c*((t=t/d-1)*t*((s+1)*t + s) + 1) + b;
            },
            easeInOutBack: function (x, t, b, c, d, s) {
                    if (s == undefined) s = 1.70158; 
                    if ((t/=d/2) < 1) return c/2*(t*t*(((s*=(1.525))+1)*t - s)) + b;
                    return c/2*((t-=2)*t*(((s*=(1.525))+1)*t + s) + 2) + b;
            },
            easeInBounce: function (x, t, b, c, d) {
                    return c - $.easing.easeOutBounce (x, d-t, 0, c, d) + b;
            },
            easeOutBounce: function (x, t, b, c, d) {
                    if ((t/=d) < (1/2.75)) {
                            return c*(7.5625*t*t) + b;
                    } else if (t < (2/2.75)) {
                            return c*(7.5625*(t-=(1.5/2.75))*t + .75) + b;
                    } else if (t < (2.5/2.75)) {
                            return c*(7.5625*(t-=(2.25/2.75))*t + .9375) + b;
                    } else {
                            return c*(7.5625*(t-=(2.625/2.75))*t + .984375) + b;
                    }
            },
            easeInOutBounce: function (x, t, b, c, d) {
                    if (t < d/2) return $.easing.easeInBounce (x, t*2, 0, c, d) * .5 + b;
                    return $.easing.easeOutBounce (x, t*2-d, 0, c, d) * .5 + c*.5 + b;
            }
    });
    
    $.fn.animatescroll = function(options) {
        
        // fetches options
        var opts = $.extend({},$.fn.animatescroll.defaults,options);

        // make sure the callback is a function
        if (typeof opts.onScrollStart == 'function') {
            // brings the scope to the callback
            opts.onScrollStart.call(this);
        }
                
        if(opts.element == "html,body") {
            // Get the distance of particular id or class from top
            var offset = this.offset().top;
        
            // Scroll the page to the desired position
            $(opts.element).stop().animate({ scrollTop: offset - opts.padding}, opts.scrollSpeed, opts.easing);
        }
        else {
            // Scroll the element to the desired position
            $(opts.element).stop().animate({ scrollTop: this.offset().top - this.parent().offset().top + this.parent().scrollTop() - opts.padding}, opts.scrollSpeed, opts.easing);
        }

        setTimeout(function() {

            // make sure the callback is a function
            if (typeof opts.onScrollEnd == 'function') {
                // brings the scope to the callback
                opts.onScrollEnd.call(this);
            }
        }, opts.scrollSpeed);
    };
    
    // default options
    $.fn.animatescroll.defaults = {        
        easing:"swing",
        scrollSpeed:800,
        padding:0,
        element:"html,body"
    };   
    
}(jQuery));
/**
 * isMobile.js v0.3.9
 *
 * A simple library to detect Apple phones and tablets,
 * Android phones and tablets, other mobile devices (like blackberry, mini-opera and windows phone),
 * and any kind of seven inch device, via user agent sniffing.
 *
 * @author: Kai Mallea (kmallea@gmail.com)
 *
 * @license: http://creativecommons.org/publicdomain/zero/1.0/
 */
(function (global) {

    var apple_phone         = /iPhone/i,
        apple_ipod          = /iPod/i,
        apple_tablet        = /iPad/i,
        android_phone       = /(?=.*\bAndroid\b)(?=.*\bMobile\b)/i, // Match 'Android' AND 'Mobile'
        android_tablet      = /Android/i,
        amazon_phone        = /(?=.*\bAndroid\b)(?=.*\bSD4930UR\b)/i,
        amazon_tablet       = /(?=.*\bAndroid\b)(?=.*\b(?:KFOT|KFTT|KFJWI|KFJWA|KFSOWI|KFTHWI|KFTHWA|KFAPWI|KFAPWA|KFARWI|KFASWI|KFSAWI|KFSAWA)\b)/i,
        windows_phone       = /IEMobile/i,
        windows_tablet      = /(?=.*\bWindows\b)(?=.*\bARM\b)/i, // Match 'Windows' AND 'ARM'
        other_blackberry    = /BlackBerry/i,
        other_blackberry_10 = /BB10/i,
        other_opera         = /Opera Mini/i,
        other_chrome        = /(CriOS|Chrome)(?=.*\bMobile\b)/i,
        other_firefox       = /(?=.*\bFirefox\b)(?=.*\bMobile\b)/i, // Match 'Firefox' AND 'Mobile'
        seven_inch = new RegExp(
            '(?:' +         // Non-capturing group

            'Nexus 7' +     // Nexus 7

            '|' +           // OR

            'BNTV250' +     // B&N Nook Tablet 7 inch

            '|' +           // OR

            'Kindle Fire' + // Kindle Fire

            '|' +           // OR

            'Silk' +        // Kindle Fire, Silk Accelerated

            '|' +           // OR

            'GT-P1000' +    // Galaxy Tab 7 inch

            ')',            // End non-capturing group

            'i');           // Case-insensitive matching

    var match = function(regex, userAgent) {
        return regex.test(userAgent);
    };

    var IsMobileClass = function(userAgent) {
        var ua = userAgent || navigator.userAgent;
        // Facebook mobile app's integrated browser adds a bunch of strings that
        // match everything. Strip it out if it exists.
        var tmp = ua.split('[FBAN');
        if (typeof tmp[1] !== 'undefined') {
            ua = tmp[0];
        }

        this.apple = {
            phone:  match(apple_phone, ua),
            ipod:   match(apple_ipod, ua),
            tablet: !match(apple_phone, ua) && match(apple_tablet, ua),
            device: match(apple_phone, ua) || match(apple_ipod, ua) || match(apple_tablet, ua)
        };
        this.amazon = {
            phone:  match(amazon_phone, ua),
            tablet: !match(amazon_phone, ua) && match(amazon_tablet, ua),
            device: match(amazon_phone, ua) || match(amazon_tablet, ua)
        };
        this.android = {
            phone:  match(amazon_phone, ua) || match(android_phone, ua),
            tablet: !match(amazon_phone, ua) && !match(android_phone, ua) && (match(amazon_tablet, ua) || match(android_tablet, ua)),
            device: match(amazon_phone, ua) || match(amazon_tablet, ua) || match(android_phone, ua) || match(android_tablet, ua)
        };
        this.windows = {
            phone:  match(windows_phone, ua),
            tablet: match(windows_tablet, ua),
            device: match(windows_phone, ua) || match(windows_tablet, ua)
        };
        this.other = {
            blackberry:   match(other_blackberry, ua),
            blackberry10: match(other_blackberry_10, ua),
            opera:        match(other_opera, ua),
            firefox:      match(other_firefox, ua),
            chrome:       match(other_chrome, ua),
            device:       match(other_blackberry, ua) || match(other_blackberry_10, ua) || match(other_opera, ua) || match(other_firefox, ua) || match(other_chrome, ua)
        };
        this.seven_inch = match(seven_inch, ua);
        this.any = this.apple.device || this.android.device || this.windows.device || this.other.device || this.seven_inch;
        // excludes 'other' devices and ipods, targeting touchscreen phones
        this.phone = this.apple.phone || this.android.phone || this.windows.phone;
        // excludes 7 inch devices, classifying as phone or tablet is left to the user
        this.tablet = this.apple.tablet || this.android.tablet || this.windows.tablet;

        if (typeof window === 'undefined') {
            return this;
        }
    };

    var instantiate = function() {
        var IM = new IsMobileClass();
        IM.Class = IsMobileClass;
        return IM;
    };

    if (typeof module != 'undefined' && module.exports && typeof window === 'undefined') {
        //node
        module.exports = IsMobileClass;
    } else if (typeof module != 'undefined' && module.exports && typeof window !== 'undefined') {
        //browserify
        module.exports = instantiate();
    } else if (typeof define === 'function' && define.amd) {
        //AMD
        define('isMobile', [], global.isMobile = instantiate());
    } else {
        global.isMobile = instantiate();
    }

})(this);

/*! threesixty-slider 2015-01-06 verison 2.0.5 */
/* http://github.com/vml-webdev/threesixty-slider.git */
!function(a){"use strict";a.ThreeSixty=function(b,c){var d,e=this,f=[];e.$el=a(b),e.el=b,e.$el.data("ThreeSixty",e),e.init=function(){d=a.extend({},a.ThreeSixty.defaultOptions,c),d.disableSpin&&(d.currentFrame=1,d.endFrame=1),e.initProgress(),e.loadImages()},e.resize=function(){},e.initProgress=function(){e.$el.css({width:d.width+"px",height:d.height+"px","background-image":"none !important"}),d.styles&&e.$el.css(d.styles),e.responsive(),e.$el.find(d.progress).css({marginTop:d.height/2-15+"px"}),e.$el.find(d.progress).fadeIn("slow"),e.$el.find(d.imgList).hide()},e.loadImages=function(){var b,c,g,h;b=document.createElement("li"),h=d.zeroBased?0:1,c=d.imgArray?d.imgArray[d.loadedImages]:d.domain+d.imagePath+d.filePrefix+e.zeroPad(d.loadedImages+h)+d.ext+(e.browser.isIE()?"?"+(new Date).getTime():""),g=a("<img>").attr("src",c).addClass("previous-image").appendTo(b),f.push(g),e.$el.find(d.imgList).append(b),a(g).load(function(){e.imageLoaded()})},e.imageLoaded=function(){d.loadedImages+=1,a(d.progress+" span").text(Math.floor(100*(d.loadedImages/d.totalFrames))+"%"),d.loadedImages>=d.totalFrames?(d.disableSpin&&f[0].removeClass("previous-image").addClass("current-image"),a(d.progress).fadeOut("slow",function(){a(this).hide(),e.showImages(),e.showNavigation()})):e.loadImages()},e.showImages=function(){e.$el.find(".txtC").fadeIn(),e.$el.find(d.imgList).fadeIn(),e.ready=!0,d.ready=!0,d.drag&&e.initEvents(),e.refresh(),e.initPlugins(),d.onReady(),setTimeout(function(){e.responsive()},50)},e.initPlugins=function(){a.each(d.plugins,function(b,c){if("function"!=typeof a[c])throw new Error(c+" not available.");a[c].call(e,e.$el,d)})},e.showNavigation=function(){if(d.navigation&&!d.navigation_init){var b,c,f,g;b=a("<div/>").attr("class","nav_bar"),c=a("<a/>").attr({href:"#","class":"nav_bar_next"}).html("next"),f=a("<a/>").attr({href:"#","class":"nav_bar_previous"}).html("previous"),g=a("<a/>").attr({href:"#","class":"nav_bar_play"}).html("play"),b.append(f),b.append(g),b.append(c),e.$el.prepend(b),c.bind("mousedown touchstart",e.next),f.bind("mousedown touchstart",e.previous),g.bind("mousedown touchstart",e.play_stop),d.navigation_init=!0}},e.play_stop=function(b){b.preventDefault(),d.autoplay?(d.autoplay=!1,a(b.currentTarget).removeClass("nav_bar_stop").addClass("nav_bar_play"),clearInterval(d.play),d.play=null):(d.autoplay=!0,d.play=setInterval(e.moveToNextFrame,d.playSpeed),a(b.currentTarget).removeClass("nav_bar_play").addClass("nav_bar_stop"))},e.next=function(a){a&&a.preventDefault(),d.endFrame-=5,e.refresh()},e.previous=function(a){a&&a.preventDefault(),d.endFrame+=5,e.refresh()},e.play=function(a){var b=a||d.playSpeed;d.autoplay||(d.autoplay=!0,d.play=setInterval(e.moveToNextFrame,b))},e.stop=function(){d.autoplay&&(d.autoplay=!1,clearInterval(d.play),d.play=null)},e.moveToNextFrame=function(){1===d.autoplayDirection?d.endFrame-=1:d.endFrame+=1,e.refresh()},e.gotoAndPlay=function(a){if(d.disableWrap)d.endFrame=a,e.refresh();else{var b=Math.ceil(d.endFrame/d.totalFrames);0===b&&(b=1);var c=b>1?d.endFrame-(b-1)*d.totalFrames:d.endFrame,f=d.totalFrames-c,g=0;g=a-c>0?a-c<c+(d.totalFrames-a)?d.endFrame+(a-c):d.endFrame-(c+(d.totalFrames-a)):f+a>c-a?d.endFrame-(c-a):d.endFrame+(f+a),c!==a&&(d.endFrame=g,e.refresh())}},e.initEvents=function(){e.$el.bind("mousedown touchstart touchmove touchend mousemove click",function(a){a.preventDefault(),"mousedown"===a.type&&1===a.which||"touchstart"===a.type?(d.pointerStartPosX=e.getPointerEvent(a).pageX,d.dragging=!0):"touchmove"===a.type?e.trackPointer(a):"touchend"===a.type&&(d.dragging=!1)}),a(document).bind("mouseup",function(){d.dragging=!1,a(this).css("cursor","none")}),a(window).bind("resize",function(){e.responsive()}),a(document).bind("mousemove",function(a){d.dragging?(a.preventDefault(),!e.browser.isIE&&d.showCursor&&e.$el.css("cursor","url(assets/images/hand_closed.png), auto")):!e.browser.isIE&&d.showCursor&&e.$el.css("cursor","url(assets/images/hand_open.png), auto"),e.trackPointer(a)}),a(window).resize(function(){e.resize()})},e.getPointerEvent=function(a){return a.originalEvent.targetTouches?a.originalEvent.targetTouches[0]:a},e.trackPointer=function(a){d.ready&&d.dragging&&(d.pointerEndPosX=e.getPointerEvent(a).pageX,d.monitorStartTime<(new Date).getTime()-d.monitorInt&&(d.pointerDistance=d.pointerEndPosX-d.pointerStartPosX,d.endFrame=d.pointerDistance>0?d.currentFrame+Math.ceil((d.totalFrames-1)*d.speedMultiplier*(d.pointerDistance/e.$el.width())):d.currentFrame+Math.floor((d.totalFrames-1)*d.speedMultiplier*(d.pointerDistance/e.$el.width())),d.disableWrap&&(d.endFrame=Math.min(d.totalFrames-(d.zeroBased?1:0),d.endFrame),d.endFrame=Math.max(d.zeroBased?0:1,d.endFrame)),e.refresh(),d.monitorStartTime=(new Date).getTime(),d.pointerStartPosX=e.getPointerEvent(a).pageX))},e.refresh=function(){0===d.ticker&&(d.ticker=setInterval(e.render,Math.round(1e3/d.framerate)))},e.render=function(){var a;d.currentFrame!==d.endFrame?(a=d.endFrame<d.currentFrame?Math.floor(.1*(d.endFrame-d.currentFrame)):Math.ceil(.1*(d.endFrame-d.currentFrame)),e.hidePreviousFrame(),d.currentFrame+=a,e.showCurrentFrame(),e.$el.trigger("frameIndexChanged",[e.getNormalizedCurrentFrame(),d.totalFrames])):(window.clearInterval(d.ticker),d.ticker=0)},e.hidePreviousFrame=function(){f[e.getNormalizedCurrentFrame()].removeClass("current-image").addClass("previous-image")},e.showCurrentFrame=function(){f[e.getNormalizedCurrentFrame()].removeClass("previous-image").addClass("current-image")},e.getNormalizedCurrentFrame=function(){var a,b;return d.disableWrap?(a=Math.min(d.currentFrame,d.totalFrames-(d.zeroBased?1:0)),b=Math.min(d.endFrame,d.totalFrames-(d.zeroBased?1:0)),a=Math.max(a,d.zeroBased?0:1),b=Math.max(b,d.zeroBased?0:1),d.currentFrame=a,d.endFrame=b):(a=Math.ceil(d.currentFrame%d.totalFrames),0>a&&(a+=d.totalFrames-(d.zeroBased?1:0))),a},e.getCurrentFrame=function(){return d.currentFrame},e.responsive=function(){d.responsive&&e.$el.css({height:e.$el.find(".current-image").first().css("height"),width:"100%"})},e.zeroPad=function(a){function b(a,b){var c=a.toString();if(d.zeroPadding)for(;c.length<b;)c="0"+c;return c}var c=Math.log(d.totalFrames)/Math.LN10,e=1e3,f=Math.round(c*e)/e,g=Math.floor(f)+1;return b(a,g)},e.browser={},e.browser.isIE=function(){var a=-1;if("Microsoft Internet Explorer"===navigator.appName){var b=navigator.userAgent,c=new RegExp("MSIE ([0-9]{1,}[\\.0-9]{0,})");null!==c.exec(b)&&(a=parseFloat(RegExp.$1))}return-1!==a},e.getConfig=function(){return d},a.ThreeSixty.defaultOptions={dragging:!1,ready:!1,pointerStartPosX:0,pointerEndPosX:0,pointerDistance:0,monitorStartTime:0,monitorInt:10,ticker:0,speedMultiplier:7,totalFrames:180,currentFrame:0,endFrame:0,loadedImages:0,framerate:60,domains:null,domain:"",parallel:!1,queueAmount:8,idle:0,filePrefix:"",ext:"png",height:300,width:300,styles:{},navigation:!1,autoplay:!1,autoplayDirection:1,disableSpin:!1,disableWrap:!1,responsive:!1,zeroPadding:!1,zeroBased:!1,plugins:[],showCursor:!1,drag:!0,onReady:function(){},imgList:".threesixty_images",imgArray:null,playSpeed:100},e.init()},a.fn.ThreeSixty=function(b){return Object.create(new a.ThreeSixty(this,b))}}(jQuery),"function"!=typeof Object.create&&(Object.create=function(a){"use strict";function b(){}return b.prototype=a,new b});
/*
 jQuery Simple Slider

 Copyright (c) 2012 James Smith (http://loopj.com)

 Licensed under the MIT license (http://mit-license.org/)
*/

var __slice = [].slice,
  __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

(function($, window) {
    var SimpleSlider;
    if (__indexOf.call(window, 'ontouchstart') >= 0) {
      $('html').addClass('touch');
    }
    SimpleSlider = (function() {

    function SimpleSlider(input, options) {
      var ratio,
        _this = this;
      this.input = input;
      this.defaultOptions = {
        animate: true,
        snapMid: false,
        classPrefix: null,
        classSuffix: null,
        theme: null,
        highlight: false
      };
      this.settings = $.extend({}, this.defaultOptions, options);
      if (this.settings.theme) {
        this.settings.classSuffix = "-" + this.settings.theme;
      }
      this.input.hide();
      this.slider = $("<div>").addClass("slider" + (this.settings.classSuffix || "")).css({
        position: "relative",
        userSelect: "none",
        boxSizing: "border-box"
      }).insertBefore(this.input);
      if (this.input.attr("id")) {
        this.slider.attr("id", this.input.attr("id") + "-slider");
      }
      this.track = this.createDivElement("track").css({
        width: "100%"
      });
      if (this.settings.highlight) {
        this.highlightTrack = this.createDivElement("highlight-track").css({
          width: "0"
        });
      }
      this.dragger = this.createDivElement("dragger");
      this.slider.css({
        minHeight: this.dragger.outerHeight(),
        marginLeft: this.dragger.outerWidth() / 2,
        marginRight: this.dragger.outerWidth() / 2
      });
      this.track.css({
        marginTop: this.track.outerHeight() / -2
      });
      if (this.settings.highlight) {
        this.highlightTrack.css({
          marginTop: this.track.outerHeight() / -2
        });
      }
      this.dragger.css({
        marginTop: this.dragger.outerWidth() / -2,
        marginLeft: this.dragger.outerWidth() / -2
      });
      this.track.mousedown(function(e) {
        return _this.trackEvent(e);
      });
      if (this.settings.highlight) {
        this.highlightTrack.mousedown(function(e) {
          return _this.trackEvent(e);
        });
      }
        this.dragger.on('touchstart mousedown', function(evt) {
          if (evt.type === "mousedown") {
            if (evt.which !== 1) {
              return;
            }
            evt.preventDefault();
          }
        _this.dragging = true;
        _this.dragger.addClass("dragging");
        _this.domDrag(evt);
        return false;
      });
        $("body").on('touchmove mousemove', function(evt) {
          if (evt.type === "mousemove") {
            evt.preventDefault();
          }
          if (_this.dragging) {
          _this.domDrag(evt);
          return $("body").css({
            cursor: "pointer"
          });
        }
      });
      $("body").on('touchend mouseup', function() {
        if (_this.dragging) {
          _this.dragging = false;
          _this.dragger.removeClass("dragging");
          return $("body").css({
            cursor: "auto"
          });
        }
      });
      this.pagePos = 0;
      if (this.input.val() === "") {
        this.value = this.getRange().min;
        this.input.val(this.value);
      } else {
        this.value = this.nearestValidValue(this.input.val());
      }
      this.setSliderPositionFromValue(this.value);
      ratio = this.valueToRatio(this.value);
      this.input.trigger("slider:ready", {
        value: this.value,
        ratio: ratio,
        position: ratio * this.slider.outerWidth(),
        el: this.slider
      });
    }

    SimpleSlider.prototype.createDivElement = function(classname) {
      var item;
      item = $("<div>").addClass(classname).css({
        position: "absolute",
        top: "50%",
        userSelect: "none",
        cursor: "pointer"
      }).appendTo(this.slider);
      return item;
    };

    SimpleSlider.prototype.setRatio = function(ratio) {
      var value;
      ratio = Math.min(1, ratio);
      ratio = Math.max(0, ratio);
      value = this.ratioToValue(ratio);
      this.setSliderPositionFromValue(value);
      return this.valueChanged(value, ratio, "setRatio");
    };

    SimpleSlider.prototype.setValue = function(value) {
      var ratio;
      value = this.nearestValidValue(value);
      ratio = this.valueToRatio(value);
      this.setSliderPositionFromValue(value);
      return this.valueChanged(value, ratio, "setValue");
    };

    SimpleSlider.prototype.trackEvent = function(evt) {
      if (evt.which !== 1) {
        return;
      }
      this.domDrag(evt, true);
      this.dragging = true;
      return false;
    };

      SimpleSlider.prototype.domDrag = function(evt, animate) {
        var pagePos, pageX, pageY, ratio, value, _ref, _ref1;
        if (animate == null) {
          animate = false;
        }
        if (evt.originalEvent && evt.originalEvent.touches) {
          _ref = evt.originalEvent.touches[0], pageX = _ref.pageX, pageY = _ref.pageY;
        } else if (evt.touches) {
          _ref1 = evt.touches[0], pageX = _ref1.pageX, pageY = _ref1.pageY;
        } else {
          pageX = evt.pageX, pageY = evt.pageY;
        }
        pagePos = pageX - this.slider.offset().left;
        pagePos = Math.min(this.slider.outerWidth(), pagePos);
        pagePos = Math.max(0, pagePos);
        if (this.pagePos !== pagePos) {
          this.pagePos = pagePos;
          ratio = pagePos / this.slider.outerWidth();
          value = this.ratioToValue(ratio);
          this.valueChanged(value, ratio, "domDrag");
          if (this.settings.snap) {
            return this.setSliderPositionFromValue(value, animate);
          } else {
            return this.setSliderPosition(pagePos, animate);
          }
        }
      };

    SimpleSlider.prototype.setSliderPosition = function(position, animate) {
      if (animate == null) {
        animate = false;
      }
      if (animate && this.settings.animate) {
        this.dragger.animate({
          left: position
        }, 200);
        if (this.settings.highlight) {
          return this.highlightTrack.animate({
            width: position
          }, 200);
        }
      } else {
        this.dragger.css({
          left: position
        });
        if (this.settings.highlight) {
          return this.highlightTrack.css({
            width: position
          });
        }
      }
    };

    SimpleSlider.prototype.setSliderPositionFromValue = function(value, animate) {
      var ratio;
      if (animate == null) {
        animate = false;
      }
      ratio = this.valueToRatio(value);
      return this.setSliderPosition(ratio * this.slider.outerWidth(), animate);
    };

    SimpleSlider.prototype.getRange = function() {
      if (this.settings.allowedValues) {
        return {
          min: Math.min.apply(Math, this.settings.allowedValues),
          max: Math.max.apply(Math, this.settings.allowedValues)
        };
      } else if (this.settings.range) {
        return {
          min: parseFloat(this.settings.range[0]),
          max: parseFloat(this.settings.range[1])
        };
      } else {
        return {
          min: 0,
          max: 1
        };
      }
    };

    SimpleSlider.prototype.nearestValidValue = function(rawValue) {
      var closest, maxSteps, range, steps;
      range = this.getRange();
      rawValue = Math.min(range.max, rawValue);
      rawValue = Math.max(range.min, rawValue);
      if (this.settings.allowedValues) {
        closest = null;
        $.each(this.settings.allowedValues, function() {
          if (closest === null || Math.abs(this - rawValue) < Math.abs(closest - rawValue)) {
            return closest = this;
          }
        });
        return closest;
      } else if (this.settings.step) {
        maxSteps = (range.max - range.min) / this.settings.step;
        steps = Math.floor((rawValue - range.min) / this.settings.step);
        if ((rawValue - range.min) % this.settings.step > this.settings.step / 2 && steps < maxSteps) {
          steps += 1;
        }
        return steps * this.settings.step + range.min;
      } else {
        return rawValue;
      }
    };

    SimpleSlider.prototype.valueToRatio = function(value) {
      var allowedVal, closest, closestIdx, idx, range, _i, _len, _ref;
      if (this.settings.equalSteps) {
        _ref = this.settings.allowedValues;
        for (idx = _i = 0, _len = _ref.length; _i < _len; idx = ++_i) {
          allowedVal = _ref[idx];
          if (!(typeof closest !== "undefined" && closest !== null) || Math.abs(allowedVal - value) < Math.abs(closest - value)) {
            closest = allowedVal;
            closestIdx = idx;
          }
        }
        if (this.settings.snapMid) {
          return (closestIdx + 0.5) / this.settings.allowedValues.length;
        } else {
          return closestIdx / (this.settings.allowedValues.length - 1);
        }
      } else {
        range = this.getRange();
        return (value - range.min) / (range.max - range.min);
      }
    };

    SimpleSlider.prototype.ratioToValue = function(ratio) {
      var idx, range, rawValue, step, steps;
      if (this.settings.equalSteps) {
        steps = this.settings.allowedValues.length;
        step = Math.round(ratio * steps - 0.5);
        idx = Math.min(step, this.settings.allowedValues.length - 1);
        return this.settings.allowedValues[idx];
      } else {
        range = this.getRange();
        rawValue = ratio * (range.max - range.min) + range.min;
        return this.nearestValidValue(rawValue);
      }
    };

    SimpleSlider.prototype.valueChanged = function(value, ratio, trigger) {
      var eventData;
      if (value.toString() === this.value.toString()) {
        return;
      }
      this.value = value;
      eventData = {
        value: value,
        ratio: ratio,
        position: ratio * this.slider.outerWidth(),
        trigger: trigger,
        el: this.slider
      };
      return this.input.val(value).trigger($.Event("change", eventData)).trigger("slider:changed", eventData);
    };

    return SimpleSlider;

  })();
  $.extend($.fn, {
    simpleSlider: function() {
      var params, publicMethods, settingsOrMethod;
      settingsOrMethod = arguments[0], params = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      publicMethods = ["setRatio", "setValue"];
      return $(this).each(function() {
        var obj, settings;
        if (settingsOrMethod && __indexOf.call(publicMethods, settingsOrMethod) >= 0) {
          obj = $(this).data("slider-object");
          return obj[settingsOrMethod].apply(obj, params);
        } else {
          settings = settingsOrMethod;
          return $(this).data("slider-object", new SimpleSlider($(this), settings));
        }
      });
    }
  });
  return $(function() {
    return $("[data-slider]").each(function() {
      var $el, allowedValues, settings, x;
      $el = $(this);
      settings = {};
      allowedValues = $el.data("slider-values");
      if (allowedValues) {
        settings.allowedValues = (function() {
          var _i, _len, _ref, _results;
          _ref = allowedValues.split(",");
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            x = _ref[_i];
            _results.push(parseFloat(x));
          }
          return _results;
        })();
      }
      if ($el.data("slider-range")) {
        settings.range = $el.data("slider-range").split(",");
      }
      if ($el.data("slider-step")) {
        settings.step = $el.data("slider-step");
      }
      settings.snap = $el.data("slider-snap");
      settings.equalSteps = $el.data("slider-equal-steps");
      if ($el.data("slider-theme")) {
        settings.theme = $el.data("slider-theme");
      }
      if ($el.attr("data-slider-highlight")) {
        settings.highlight = $el.data("slider-highlight");
      }
      if ($el.data("slider-animate") != null) {
        settings.animate = $el.data("slider-animate");
      }
      return $el.simpleSlider(settings);
    });
  });
})(this.jQuery || this.Zepto, this);

/*
     _ _      _       _
 ___| (_) ___| | __  (_)___
/ __| | |/ __| |/ /  | / __|
\__ \ | | (__|   < _ | \__ \
|___/_|_|\___|_|\_(_)/ |___/
                   |__/

 Version: 1.5.8
  Author: Ken Wheeler
 Website: http://kenwheeler.github.io
    Docs: http://kenwheeler.github.io/slick
    Repo: http://github.com/kenwheeler/slick
  Issues: http://github.com/kenwheeler/slick/issues

 */
!function(a){"use strict";"function"==typeof define&&define.amd?define(["jquery"],a):"undefined"!=typeof exports?module.exports=a(require("jquery")):a(jQuery)}(function(a){"use strict";var b=window.Slick||{};b=function(){function c(c,d){var f,e=this;e.defaults={accessibility:!0,adaptiveHeight:!1,appendArrows:a(c),appendDots:a(c),arrows:!0,asNavFor:null,prevArrow:'<button type="button" data-role="none" class="slick-prev" aria-label="Previous" tabindex="0" role="button">Previous</button>',nextArrow:'<button type="button" data-role="none" class="slick-next" aria-label="Next" tabindex="0" role="button">Next</button>',autoplay:!1,autoplaySpeed:3e3,centerMode:!1,centerPadding:"50px",cssEase:"ease",customPaging:function(a,b){return'<button type="button" data-role="none" role="button" aria-required="false" tabindex="0">'+(b+1)+"</button>"},dots:!1,dotsClass:"slick-dots",draggable:!0,easing:"linear",edgeFriction:.35,fade:!1,focusOnSelect:!1,infinite:!0,initialSlide:0,lazyLoad:"ondemand",mobileFirst:!1,pauseOnHover:!0,pauseOnDotsHover:!1,respondTo:"window",responsive:null,rows:1,rtl:!1,slide:"",slidesPerRow:1,slidesToShow:1,slidesToScroll:1,speed:500,swipe:!0,swipeToSlide:!1,touchMove:!0,touchThreshold:5,useCSS:!0,variableWidth:!1,vertical:!1,verticalSwiping:!1,waitForAnimate:!0,zIndex:1e3},e.initials={animating:!1,dragging:!1,autoPlayTimer:null,currentDirection:0,currentLeft:null,currentSlide:0,direction:1,$dots:null,listWidth:null,listHeight:null,loadIndex:0,$nextArrow:null,$prevArrow:null,slideCount:null,slideWidth:null,$slideTrack:null,$slides:null,sliding:!1,slideOffset:0,swipeLeft:null,$list:null,touchObject:{},transformsEnabled:!1,unslicked:!1},a.extend(e,e.initials),e.activeBreakpoint=null,e.animType=null,e.animProp=null,e.breakpoints=[],e.breakpointSettings=[],e.cssTransitions=!1,e.hidden="hidden",e.paused=!1,e.positionProp=null,e.respondTo=null,e.rowCount=1,e.shouldClick=!0,e.$slider=a(c),e.$slidesCache=null,e.transformType=null,e.transitionType=null,e.visibilityChange="visibilitychange",e.windowWidth=0,e.windowTimer=null,f=a(c).data("slick")||{},e.options=a.extend({},e.defaults,f,d),e.currentSlide=e.options.initialSlide,e.originalSettings=e.options,"undefined"!=typeof document.mozHidden?(e.hidden="mozHidden",e.visibilityChange="mozvisibilitychange"):"undefined"!=typeof document.webkitHidden&&(e.hidden="webkitHidden",e.visibilityChange="webkitvisibilitychange"),e.autoPlay=a.proxy(e.autoPlay,e),e.autoPlayClear=a.proxy(e.autoPlayClear,e),e.changeSlide=a.proxy(e.changeSlide,e),e.clickHandler=a.proxy(e.clickHandler,e),e.selectHandler=a.proxy(e.selectHandler,e),e.setPosition=a.proxy(e.setPosition,e),e.swipeHandler=a.proxy(e.swipeHandler,e),e.dragHandler=a.proxy(e.dragHandler,e),e.keyHandler=a.proxy(e.keyHandler,e),e.autoPlayIterator=a.proxy(e.autoPlayIterator,e),e.instanceUid=b++,e.htmlExpr=/^(?:\s*(<[\w\W]+>)[^>]*)$/,e.registerBreakpoints(),e.init(!0),e.checkResponsive(!0)}var b=0;return c}(),b.prototype.addSlide=b.prototype.slickAdd=function(b,c,d){var e=this;if("boolean"==typeof c)d=c,c=null;else if(0>c||c>=e.slideCount)return!1;e.unload(),"number"==typeof c?0===c&&0===e.$slides.length?a(b).appendTo(e.$slideTrack):d?a(b).insertBefore(e.$slides.eq(c)):a(b).insertAfter(e.$slides.eq(c)):d===!0?a(b).prependTo(e.$slideTrack):a(b).appendTo(e.$slideTrack),e.$slides=e.$slideTrack.children(this.options.slide),e.$slideTrack.children(this.options.slide).detach(),e.$slideTrack.append(e.$slides),e.$slides.each(function(b,c){a(c).attr("data-slick-index",b)}),e.$slidesCache=e.$slides,e.reinit()},b.prototype.animateHeight=function(){var a=this;if(1===a.options.slidesToShow&&a.options.adaptiveHeight===!0&&a.options.vertical===!1){var b=a.$slides.eq(a.currentSlide).outerHeight(!0);a.$list.animate({height:b},a.options.speed)}},b.prototype.animateSlide=function(b,c){var d={},e=this;e.animateHeight(),e.options.rtl===!0&&e.options.vertical===!1&&(b=-b),e.transformsEnabled===!1?e.options.vertical===!1?e.$slideTrack.animate({left:b},e.options.speed,e.options.easing,c):e.$slideTrack.animate({top:b},e.options.speed,e.options.easing,c):e.cssTransitions===!1?(e.options.rtl===!0&&(e.currentLeft=-e.currentLeft),a({animStart:e.currentLeft}).animate({animStart:b},{duration:e.options.speed,easing:e.options.easing,step:function(a){a=Math.ceil(a),e.options.vertical===!1?(d[e.animType]="translate("+a+"px, 0px)",e.$slideTrack.css(d)):(d[e.animType]="translate(0px,"+a+"px)",e.$slideTrack.css(d))},complete:function(){c&&c.call()}})):(e.applyTransition(),b=Math.ceil(b),d[e.animType]=e.options.vertical===!1?"translate3d("+b+"px, 0px, 0px)":"translate3d(0px,"+b+"px, 0px)",e.$slideTrack.css(d),c&&setTimeout(function(){e.disableTransition(),c.call()},e.options.speed))},b.prototype.asNavFor=function(b){var c=this,d=c.options.asNavFor;d&&null!==d&&(d=a(d).not(c.$slider)),null!==d&&"object"==typeof d&&d.each(function(){var c=a(this).slick("getSlick");c.unslicked||c.slideHandler(b,!0)})},b.prototype.applyTransition=function(a){var b=this,c={};c[b.transitionType]=b.options.fade===!1?b.transformType+" "+b.options.speed+"ms "+b.options.cssEase:"opacity "+b.options.speed+"ms "+b.options.cssEase,b.options.fade===!1?b.$slideTrack.css(c):b.$slides.eq(a).css(c)},b.prototype.autoPlay=function(){var a=this;a.autoPlayTimer&&clearInterval(a.autoPlayTimer),a.slideCount>a.options.slidesToShow&&a.paused!==!0&&(a.autoPlayTimer=setInterval(a.autoPlayIterator,a.options.autoplaySpeed))},b.prototype.autoPlayClear=function(){var a=this;a.autoPlayTimer&&clearInterval(a.autoPlayTimer)},b.prototype.autoPlayIterator=function(){var a=this;a.options.infinite===!1?1===a.direction?(a.currentSlide+1===a.slideCount-1&&(a.direction=0),a.slideHandler(a.currentSlide+a.options.slidesToScroll)):(0===a.currentSlide-1&&(a.direction=1),a.slideHandler(a.currentSlide-a.options.slidesToScroll)):a.slideHandler(a.currentSlide+a.options.slidesToScroll)},b.prototype.buildArrows=function(){var b=this;b.options.arrows===!0&&(b.$prevArrow=a(b.options.prevArrow).addClass("slick-arrow"),b.$nextArrow=a(b.options.nextArrow).addClass("slick-arrow"),b.slideCount>b.options.slidesToShow?(b.$prevArrow.removeClass("slick-hidden").removeAttr("aria-hidden tabindex"),b.$nextArrow.removeClass("slick-hidden").removeAttr("aria-hidden tabindex"),b.htmlExpr.test(b.options.prevArrow)&&b.$prevArrow.prependTo(b.options.appendArrows),b.htmlExpr.test(b.options.nextArrow)&&b.$nextArrow.appendTo(b.options.appendArrows),b.options.infinite!==!0&&b.$prevArrow.addClass("slick-disabled").attr("aria-disabled","true")):b.$prevArrow.add(b.$nextArrow).addClass("slick-hidden").attr({"aria-disabled":"true",tabindex:"-1"}))},b.prototype.buildDots=function(){var c,d,b=this;if(b.options.dots===!0&&b.slideCount>b.options.slidesToShow){for(d='<ul class="'+b.options.dotsClass+'">',c=0;c<=b.getDotCount();c+=1)d+="<li>"+b.options.customPaging.call(this,b,c)+"</li>";d+="</ul>",b.$dots=a(d).appendTo(b.options.appendDots),b.$dots.find("li").first().addClass("slick-active").attr("aria-hidden","false")}},b.prototype.buildOut=function(){var b=this;b.$slides=b.$slider.children(b.options.slide+":not(.slick-cloned)").addClass("slick-slide"),b.slideCount=b.$slides.length,b.$slides.each(function(b,c){a(c).attr("data-slick-index",b).data("originalStyling",a(c).attr("style")||"")}),b.$slidesCache=b.$slides,b.$slider.addClass("slick-slider"),b.$slideTrack=0===b.slideCount?a('<div class="slick-track"/>').appendTo(b.$slider):b.$slides.wrapAll('<div class="slick-track"/>').parent(),b.$list=b.$slideTrack.wrap('<div aria-live="polite" class="slick-list"/>').parent(),b.$slideTrack.css("opacity",0),(b.options.centerMode===!0||b.options.swipeToSlide===!0)&&(b.options.slidesToScroll=1),a("img[data-lazy]",b.$slider).not("[src]").addClass("slick-loading"),b.setupInfinite(),b.buildArrows(),b.buildDots(),b.updateDots(),b.setSlideClasses("number"==typeof b.currentSlide?b.currentSlide:0),b.options.draggable===!0&&b.$list.addClass("draggable")},b.prototype.buildRows=function(){var b,c,d,e,f,g,h,a=this;if(e=document.createDocumentFragment(),g=a.$slider.children(),a.options.rows>1){for(h=a.options.slidesPerRow*a.options.rows,f=Math.ceil(g.length/h),b=0;f>b;b++){var i=document.createElement("div");for(c=0;c<a.options.rows;c++){var j=document.createElement("div");for(d=0;d<a.options.slidesPerRow;d++){var k=b*h+(c*a.options.slidesPerRow+d);g.get(k)&&j.appendChild(g.get(k))}i.appendChild(j)}e.appendChild(i)}a.$slider.html(e),a.$slider.children().children().children().css({width:100/a.options.slidesPerRow+"%",display:"inline-block"})}},b.prototype.checkResponsive=function(b,c){var e,f,g,d=this,h=!1,i=d.$slider.width(),j=window.innerWidth||a(window).width();if("window"===d.respondTo?g=j:"slider"===d.respondTo?g=i:"min"===d.respondTo&&(g=Math.min(j,i)),d.options.responsive&&d.options.responsive.length&&null!==d.options.responsive){f=null;for(e in d.breakpoints)d.breakpoints.hasOwnProperty(e)&&(d.originalSettings.mobileFirst===!1?g<d.breakpoints[e]&&(f=d.breakpoints[e]):g>d.breakpoints[e]&&(f=d.breakpoints[e]));null!==f?null!==d.activeBreakpoint?(f!==d.activeBreakpoint||c)&&(d.activeBreakpoint=f,"unslick"===d.breakpointSettings[f]?d.unslick(f):(d.options=a.extend({},d.originalSettings,d.breakpointSettings[f]),b===!0&&(d.currentSlide=d.options.initialSlide),d.refresh(b)),h=f):(d.activeBreakpoint=f,"unslick"===d.breakpointSettings[f]?d.unslick(f):(d.options=a.extend({},d.originalSettings,d.breakpointSettings[f]),b===!0&&(d.currentSlide=d.options.initialSlide),d.refresh(b)),h=f):null!==d.activeBreakpoint&&(d.activeBreakpoint=null,d.options=d.originalSettings,b===!0&&(d.currentSlide=d.options.initialSlide),d.refresh(b),h=f),b||h===!1||d.$slider.trigger("breakpoint",[d,h])}},b.prototype.changeSlide=function(b,c){var f,g,h,d=this,e=a(b.target);switch(e.is("a")&&b.preventDefault(),e.is("li")||(e=e.closest("li")),h=0!==d.slideCount%d.options.slidesToScroll,f=h?0:(d.slideCount-d.currentSlide)%d.options.slidesToScroll,b.data.message){case"previous":g=0===f?d.options.slidesToScroll:d.options.slidesToShow-f,d.slideCount>d.options.slidesToShow&&d.slideHandler(d.currentSlide-g,!1,c);break;case"next":g=0===f?d.options.slidesToScroll:f,d.slideCount>d.options.slidesToShow&&d.slideHandler(d.currentSlide+g,!1,c);break;case"index":var i=0===b.data.index?0:b.data.index||e.index()*d.options.slidesToScroll;d.slideHandler(d.checkNavigable(i),!1,c),e.children().trigger("focus");break;default:return}},b.prototype.checkNavigable=function(a){var c,d,b=this;if(c=b.getNavigableIndexes(),d=0,a>c[c.length-1])a=c[c.length-1];else for(var e in c){if(a<c[e]){a=d;break}d=c[e]}return a},b.prototype.cleanUpEvents=function(){var b=this;b.options.dots&&null!==b.$dots&&(a("li",b.$dots).off("click.slick",b.changeSlide),b.options.pauseOnDotsHover===!0&&b.options.autoplay===!0&&a("li",b.$dots).off("mouseenter.slick",a.proxy(b.setPaused,b,!0)).off("mouseleave.slick",a.proxy(b.setPaused,b,!1))),b.options.arrows===!0&&b.slideCount>b.options.slidesToShow&&(b.$prevArrow&&b.$prevArrow.off("click.slick",b.changeSlide),b.$nextArrow&&b.$nextArrow.off("click.slick",b.changeSlide)),b.$list.off("touchstart.slick mousedown.slick",b.swipeHandler),b.$list.off("touchmove.slick mousemove.slick",b.swipeHandler),b.$list.off("touchend.slick mouseup.slick",b.swipeHandler),b.$list.off("touchcancel.slick mouseleave.slick",b.swipeHandler),b.$list.off("click.slick",b.clickHandler),a(document).off(b.visibilityChange,b.visibility),b.$list.off("mouseenter.slick",a.proxy(b.setPaused,b,!0)),b.$list.off("mouseleave.slick",a.proxy(b.setPaused,b,!1)),b.options.accessibility===!0&&b.$list.off("keydown.slick",b.keyHandler),b.options.focusOnSelect===!0&&a(b.$slideTrack).children().off("click.slick",b.selectHandler),a(window).off("orientationchange.slick.slick-"+b.instanceUid,b.orientationChange),a(window).off("resize.slick.slick-"+b.instanceUid,b.resize),a("[draggable!=true]",b.$slideTrack).off("dragstart",b.preventDefault),a(window).off("load.slick.slick-"+b.instanceUid,b.setPosition),a(document).off("ready.slick.slick-"+b.instanceUid,b.setPosition)},b.prototype.cleanUpRows=function(){var b,a=this;a.options.rows>1&&(b=a.$slides.children().children(),b.removeAttr("style"),a.$slider.html(b))},b.prototype.clickHandler=function(a){var b=this;b.shouldClick===!1&&(a.stopImmediatePropagation(),a.stopPropagation(),a.preventDefault())},b.prototype.destroy=function(b){var c=this;c.autoPlayClear(),c.touchObject={},c.cleanUpEvents(),a(".slick-cloned",c.$slider).detach(),c.$dots&&c.$dots.remove(),c.$prevArrow&&c.$prevArrow.length&&(c.$prevArrow.removeClass("slick-disabled slick-arrow slick-hidden").removeAttr("aria-hidden aria-disabled tabindex").css("display",""),c.htmlExpr.test(c.options.prevArrow)&&c.$prevArrow.remove()),c.$nextArrow&&c.$nextArrow.length&&(c.$nextArrow.removeClass("slick-disabled slick-arrow slick-hidden").removeAttr("aria-hidden aria-disabled tabindex").css("display",""),c.htmlExpr.test(c.options.nextArrow)&&c.$nextArrow.remove()),c.$slides&&(c.$slides.removeClass("slick-slide slick-active slick-center slick-visible slick-current").removeAttr("aria-hidden").removeAttr("data-slick-index").each(function(){a(this).attr("style",a(this).data("originalStyling"))}),c.$slideTrack.children(this.options.slide).detach(),c.$slideTrack.detach(),c.$list.detach(),c.$slider.append(c.$slides)),c.cleanUpRows(),c.$slider.removeClass("slick-slider"),c.$slider.removeClass("slick-initialized"),c.unslicked=!0,b||c.$slider.trigger("destroy",[c])},b.prototype.disableTransition=function(a){var b=this,c={};c[b.transitionType]="",b.options.fade===!1?b.$slideTrack.css(c):b.$slides.eq(a).css(c)},b.prototype.fadeSlide=function(a,b){var c=this;c.cssTransitions===!1?(c.$slides.eq(a).css({zIndex:c.options.zIndex}),c.$slides.eq(a).animate({opacity:1},c.options.speed,c.options.easing,b)):(c.applyTransition(a),c.$slides.eq(a).css({opacity:1,zIndex:c.options.zIndex}),b&&setTimeout(function(){c.disableTransition(a),b.call()},c.options.speed))},b.prototype.fadeSlideOut=function(a){var b=this;b.cssTransitions===!1?b.$slides.eq(a).animate({opacity:0,zIndex:b.options.zIndex-2},b.options.speed,b.options.easing):(b.applyTransition(a),b.$slides.eq(a).css({opacity:0,zIndex:b.options.zIndex-2}))},b.prototype.filterSlides=b.prototype.slickFilter=function(a){var b=this;null!==a&&(b.unload(),b.$slideTrack.children(this.options.slide).detach(),b.$slidesCache.filter(a).appendTo(b.$slideTrack),b.reinit())},b.prototype.getCurrent=b.prototype.slickCurrentSlide=function(){var a=this;return a.currentSlide},b.prototype.getDotCount=function(){var a=this,b=0,c=0,d=0;if(a.options.infinite===!0)for(;b<a.slideCount;)++d,b=c+a.options.slidesToShow,c+=a.options.slidesToScroll<=a.options.slidesToShow?a.options.slidesToScroll:a.options.slidesToShow;else if(a.options.centerMode===!0)d=a.slideCount;else for(;b<a.slideCount;)++d,b=c+a.options.slidesToShow,c+=a.options.slidesToScroll<=a.options.slidesToShow?a.options.slidesToScroll:a.options.slidesToShow;return d-1},b.prototype.getLeft=function(a){var c,d,f,b=this,e=0;return b.slideOffset=0,d=b.$slides.first().outerHeight(!0),b.options.infinite===!0?(b.slideCount>b.options.slidesToShow&&(b.slideOffset=-1*b.slideWidth*b.options.slidesToShow,e=-1*d*b.options.slidesToShow),0!==b.slideCount%b.options.slidesToScroll&&a+b.options.slidesToScroll>b.slideCount&&b.slideCount>b.options.slidesToShow&&(a>b.slideCount?(b.slideOffset=-1*(b.options.slidesToShow-(a-b.slideCount))*b.slideWidth,e=-1*(b.options.slidesToShow-(a-b.slideCount))*d):(b.slideOffset=-1*b.slideCount%b.options.slidesToScroll*b.slideWidth,e=-1*b.slideCount%b.options.slidesToScroll*d))):a+b.options.slidesToShow>b.slideCount&&(b.slideOffset=(a+b.options.slidesToShow-b.slideCount)*b.slideWidth,e=(a+b.options.slidesToShow-b.slideCount)*d),b.slideCount<=b.options.slidesToShow&&(b.slideOffset=0,e=0),b.options.centerMode===!0&&b.options.infinite===!0?b.slideOffset+=b.slideWidth*Math.floor(b.options.slidesToShow/2)-b.slideWidth:b.options.centerMode===!0&&(b.slideOffset=0,b.slideOffset+=b.slideWidth*Math.floor(b.options.slidesToShow/2)),c=b.options.vertical===!1?-1*a*b.slideWidth+b.slideOffset:-1*a*d+e,b.options.variableWidth===!0&&(f=b.slideCount<=b.options.slidesToShow||b.options.infinite===!1?b.$slideTrack.children(".slick-slide").eq(a):b.$slideTrack.children(".slick-slide").eq(a+b.options.slidesToShow),c=f[0]?-1*f[0].offsetLeft:0,b.options.centerMode===!0&&(f=b.options.infinite===!1?b.$slideTrack.children(".slick-slide").eq(a):b.$slideTrack.children(".slick-slide").eq(a+b.options.slidesToShow+1),c=f[0]?-1*f[0].offsetLeft:0,c+=(b.$list.width()-f.outerWidth())/2)),c},b.prototype.getOption=b.prototype.slickGetOption=function(a){var b=this;return b.options[a]},b.prototype.getNavigableIndexes=function(){var e,a=this,b=0,c=0,d=[];for(a.options.infinite===!1?e=a.slideCount:(b=-1*a.options.slidesToScroll,c=-1*a.options.slidesToScroll,e=2*a.slideCount);e>b;)d.push(b),b=c+a.options.slidesToScroll,c+=a.options.slidesToScroll<=a.options.slidesToShow?a.options.slidesToScroll:a.options.slidesToShow;return d},b.prototype.getSlick=function(){return this},b.prototype.getSlideCount=function(){var c,d,e,b=this;return e=b.options.centerMode===!0?b.slideWidth*Math.floor(b.options.slidesToShow/2):0,b.options.swipeToSlide===!0?(b.$slideTrack.find(".slick-slide").each(function(c,f){return f.offsetLeft-e+a(f).outerWidth()/2>-1*b.swipeLeft?(d=f,!1):void 0}),c=Math.abs(a(d).attr("data-slick-index")-b.currentSlide)||1):b.options.slidesToScroll},b.prototype.goTo=b.prototype.slickGoTo=function(a,b){var c=this;c.changeSlide({data:{message:"index",index:parseInt(a)}},b)},b.prototype.init=function(b){var c=this;a(c.$slider).hasClass("slick-initialized")||(a(c.$slider).addClass("slick-initialized"),c.buildRows(),c.buildOut(),c.setProps(),c.startLoad(),c.loadSlider(),c.initializeEvents(),c.updateArrows(),c.updateDots()),b&&c.$slider.trigger("init",[c]),c.options.accessibility===!0&&c.initADA()},b.prototype.initArrowEvents=function(){var a=this;a.options.arrows===!0&&a.slideCount>a.options.slidesToShow&&(a.$prevArrow.on("click.slick",{message:"previous"},a.changeSlide),a.$nextArrow.on("click.slick",{message:"next"},a.changeSlide))},b.prototype.initDotEvents=function(){var b=this;b.options.dots===!0&&b.slideCount>b.options.slidesToShow&&a("li",b.$dots).on("click.slick",{message:"index"},b.changeSlide),b.options.dots===!0&&b.options.pauseOnDotsHover===!0&&b.options.autoplay===!0&&a("li",b.$dots).on("mouseenter.slick",a.proxy(b.setPaused,b,!0)).on("mouseleave.slick",a.proxy(b.setPaused,b,!1))},b.prototype.initializeEvents=function(){var b=this;b.initArrowEvents(),b.initDotEvents(),b.$list.on("touchstart.slick mousedown.slick",{action:"start"},b.swipeHandler),b.$list.on("touchmove.slick mousemove.slick",{action:"move"},b.swipeHandler),b.$list.on("touchend.slick mouseup.slick",{action:"end"},b.swipeHandler),b.$list.on("touchcancel.slick mouseleave.slick",{action:"end"},b.swipeHandler),b.$list.on("click.slick",b.clickHandler),a(document).on(b.visibilityChange,a.proxy(b.visibility,b)),b.$list.on("mouseenter.slick",a.proxy(b.setPaused,b,!0)),b.$list.on("mouseleave.slick",a.proxy(b.setPaused,b,!1)),b.options.accessibility===!0&&b.$list.on("keydown.slick",b.keyHandler),b.options.focusOnSelect===!0&&a(b.$slideTrack).children().on("click.slick",b.selectHandler),a(window).on("orientationchange.slick.slick-"+b.instanceUid,a.proxy(b.orientationChange,b)),a(window).on("resize.slick.slick-"+b.instanceUid,a.proxy(b.resize,b)),a("[draggable!=true]",b.$slideTrack).on("dragstart",b.preventDefault),a(window).on("load.slick.slick-"+b.instanceUid,b.setPosition),a(document).on("ready.slick.slick-"+b.instanceUid,b.setPosition)},b.prototype.initUI=function(){var a=this;a.options.arrows===!0&&a.slideCount>a.options.slidesToShow&&(a.$prevArrow.show(),a.$nextArrow.show()),a.options.dots===!0&&a.slideCount>a.options.slidesToShow&&a.$dots.show(),a.options.autoplay===!0&&a.autoPlay()},b.prototype.keyHandler=function(a){var b=this;a.target.tagName.match("TEXTAREA|INPUT|SELECT")||(37===a.keyCode&&b.options.accessibility===!0?b.changeSlide({data:{message:"previous"}}):39===a.keyCode&&b.options.accessibility===!0&&b.changeSlide({data:{message:"next"}}))},b.prototype.lazyLoad=function(){function g(b){a("img[data-lazy]",b).each(function(){var b=a(this),c=a(this).attr("data-lazy"),d=document.createElement("img");d.onload=function(){b.animate({opacity:0},100,function(){b.attr("src",c).animate({opacity:1},200,function(){b.removeAttr("data-lazy").removeClass("slick-loading")})})},d.src=c})}var c,d,e,f,b=this;b.options.centerMode===!0?b.options.infinite===!0?(e=b.currentSlide+(b.options.slidesToShow/2+1),f=e+b.options.slidesToShow+2):(e=Math.max(0,b.currentSlide-(b.options.slidesToShow/2+1)),f=2+(b.options.slidesToShow/2+1)+b.currentSlide):(e=b.options.infinite?b.options.slidesToShow+b.currentSlide:b.currentSlide,f=e+b.options.slidesToShow,b.options.fade===!0&&(e>0&&e--,f<=b.slideCount&&f++)),c=b.$slider.find(".slick-slide").slice(e,f),g(c),b.slideCount<=b.options.slidesToShow?(d=b.$slider.find(".slick-slide"),g(d)):b.currentSlide>=b.slideCount-b.options.slidesToShow?(d=b.$slider.find(".slick-cloned").slice(0,b.options.slidesToShow),g(d)):0===b.currentSlide&&(d=b.$slider.find(".slick-cloned").slice(-1*b.options.slidesToShow),g(d))},b.prototype.loadSlider=function(){var a=this;a.setPosition(),a.$slideTrack.css({opacity:1}),a.$slider.removeClass("slick-loading"),a.initUI(),"progressive"===a.options.lazyLoad&&a.progressiveLazyLoad()},b.prototype.next=b.prototype.slickNext=function(){var a=this;a.changeSlide({data:{message:"next"}})},b.prototype.orientationChange=function(){var a=this;a.checkResponsive(),a.setPosition()},b.prototype.pause=b.prototype.slickPause=function(){var a=this;a.autoPlayClear(),a.paused=!0},b.prototype.play=b.prototype.slickPlay=function(){var a=this;a.paused=!1,a.autoPlay()},b.prototype.postSlide=function(a){var b=this;b.$slider.trigger("afterChange",[b,a]),b.animating=!1,b.setPosition(),b.swipeLeft=null,b.options.autoplay===!0&&b.paused===!1&&b.autoPlay(),b.options.accessibility===!0&&b.initADA()},b.prototype.prev=b.prototype.slickPrev=function(){var a=this;a.changeSlide({data:{message:"previous"}})},b.prototype.preventDefault=function(a){a.preventDefault()},b.prototype.progressiveLazyLoad=function(){var c,d,b=this;c=a("img[data-lazy]",b.$slider).length,c>0&&(d=a("img[data-lazy]",b.$slider).first(),d.attr("src",d.attr("data-lazy")).removeClass("slick-loading").load(function(){d.removeAttr("data-lazy"),b.progressiveLazyLoad(),b.options.adaptiveHeight===!0&&b.setPosition()}).error(function(){d.removeAttr("data-lazy"),b.progressiveLazyLoad()}))},b.prototype.refresh=function(b){var c=this,d=c.currentSlide;c.destroy(!0),a.extend(c,c.initials,{currentSlide:d}),c.init(),b||c.changeSlide({data:{message:"index",index:d}},!1)},b.prototype.registerBreakpoints=function(){var c,d,e,b=this,f=b.options.responsive||null;if("array"===a.type(f)&&f.length){b.respondTo=b.options.respondTo||"window";for(c in f)if(e=b.breakpoints.length-1,d=f[c].breakpoint,f.hasOwnProperty(c)){for(;e>=0;)b.breakpoints[e]&&b.breakpoints[e]===d&&b.breakpoints.splice(e,1),e--;b.breakpoints.push(d),b.breakpointSettings[d]=f[c].settings}b.breakpoints.sort(function(a,c){return b.options.mobileFirst?a-c:c-a})}},b.prototype.reinit=function(){var b=this;b.$slides=b.$slideTrack.children(b.options.slide).addClass("slick-slide"),b.slideCount=b.$slides.length,b.currentSlide>=b.slideCount&&0!==b.currentSlide&&(b.currentSlide=b.currentSlide-b.options.slidesToScroll),b.slideCount<=b.options.slidesToShow&&(b.currentSlide=0),b.registerBreakpoints(),b.setProps(),b.setupInfinite(),b.buildArrows(),b.updateArrows(),b.initArrowEvents(),b.buildDots(),b.updateDots(),b.initDotEvents(),b.checkResponsive(!1,!0),b.options.focusOnSelect===!0&&a(b.$slideTrack).children().on("click.slick",b.selectHandler),b.setSlideClasses(0),b.setPosition(),b.$slider.trigger("reInit",[b]),b.options.autoplay===!0&&b.focusHandler()},b.prototype.resize=function(){var b=this;a(window).width()!==b.windowWidth&&(clearTimeout(b.windowDelay),b.windowDelay=window.setTimeout(function(){b.windowWidth=a(window).width(),b.checkResponsive(),b.unslicked||b.setPosition()},50))},b.prototype.removeSlide=b.prototype.slickRemove=function(a,b,c){var d=this;return"boolean"==typeof a?(b=a,a=b===!0?0:d.slideCount-1):a=b===!0?--a:a,d.slideCount<1||0>a||a>d.slideCount-1?!1:(d.unload(),c===!0?d.$slideTrack.children().remove():d.$slideTrack.children(this.options.slide).eq(a).remove(),d.$slides=d.$slideTrack.children(this.options.slide),d.$slideTrack.children(this.options.slide).detach(),d.$slideTrack.append(d.$slides),d.$slidesCache=d.$slides,d.reinit(),void 0)},b.prototype.setCSS=function(a){var d,e,b=this,c={};b.options.rtl===!0&&(a=-a),d="left"==b.positionProp?Math.ceil(a)+"px":"0px",e="top"==b.positionProp?Math.ceil(a)+"px":"0px",c[b.positionProp]=a,b.transformsEnabled===!1?b.$slideTrack.css(c):(c={},b.cssTransitions===!1?(c[b.animType]="translate("+d+", "+e+")",b.$slideTrack.css(c)):(c[b.animType]="translate3d("+d+", "+e+", 0px)",b.$slideTrack.css(c)))},b.prototype.setDimensions=function(){var a=this;a.options.vertical===!1?a.options.centerMode===!0&&a.$list.css({padding:"0px "+a.options.centerPadding}):(a.$list.height(a.$slides.first().outerHeight(!0)*a.options.slidesToShow),a.options.centerMode===!0&&a.$list.css({padding:a.options.centerPadding+" 0px"})),a.listWidth=a.$list.width(),a.listHeight=a.$list.height(),a.options.vertical===!1&&a.options.variableWidth===!1?(a.slideWidth=Math.ceil(a.listWidth/a.options.slidesToShow),a.$slideTrack.width(Math.ceil(a.slideWidth*a.$slideTrack.children(".slick-slide").length))):a.options.variableWidth===!0?a.$slideTrack.width(5e3*a.slideCount):(a.slideWidth=Math.ceil(a.listWidth),a.$slideTrack.height(Math.ceil(a.$slides.first().outerHeight(!0)*a.$slideTrack.children(".slick-slide").length)));var b=a.$slides.first().outerWidth(!0)-a.$slides.first().width();a.options.variableWidth===!1&&a.$slideTrack.children(".slick-slide").width(a.slideWidth-b)},b.prototype.setFade=function(){var c,b=this;b.$slides.each(function(d,e){c=-1*b.slideWidth*d,b.options.rtl===!0?a(e).css({position:"relative",right:c,top:0,zIndex:b.options.zIndex-2,opacity:0}):a(e).css({position:"relative",left:c,top:0,zIndex:b.options.zIndex-2,opacity:0})}),b.$slides.eq(b.currentSlide).css({zIndex:b.options.zIndex-1,opacity:1})},b.prototype.setHeight=function(){var a=this;if(1===a.options.slidesToShow&&a.options.adaptiveHeight===!0&&a.options.vertical===!1){var b=a.$slides.eq(a.currentSlide).outerHeight(!0);a.$list.css("height",b)}},b.prototype.setOption=b.prototype.slickSetOption=function(b,c,d){var f,g,e=this;if("responsive"===b&&"array"===a.type(c))for(g in c)if("array"!==a.type(e.options.responsive))e.options.responsive=[c[g]];else{for(f=e.options.responsive.length-1;f>=0;)e.options.responsive[f].breakpoint===c[g].breakpoint&&e.options.responsive.splice(f,1),f--;e.options.responsive.push(c[g])}else e.options[b]=c;d===!0&&(e.unload(),e.reinit())},b.prototype.setPosition=function(){var a=this;a.setDimensions(),a.setHeight(),a.options.fade===!1?a.setCSS(a.getLeft(a.currentSlide)):a.setFade(),a.$slider.trigger("setPosition",[a])},b.prototype.setProps=function(){var a=this,b=document.body.style;a.positionProp=a.options.vertical===!0?"top":"left","top"===a.positionProp?a.$slider.addClass("slick-vertical"):a.$slider.removeClass("slick-vertical"),(void 0!==b.WebkitTransition||void 0!==b.MozTransition||void 0!==b.msTransition)&&a.options.useCSS===!0&&(a.cssTransitions=!0),a.options.fade&&("number"==typeof a.options.zIndex?a.options.zIndex<3&&(a.options.zIndex=3):a.options.zIndex=a.defaults.zIndex),void 0!==b.OTransform&&(a.animType="OTransform",a.transformType="-o-transform",a.transitionType="OTransition",void 0===b.perspectiveProperty&&void 0===b.webkitPerspective&&(a.animType=!1)),void 0!==b.MozTransform&&(a.animType="MozTransform",a.transformType="-moz-transform",a.transitionType="MozTransition",void 0===b.perspectiveProperty&&void 0===b.MozPerspective&&(a.animType=!1)),void 0!==b.webkitTransform&&(a.animType="webkitTransform",a.transformType="-webkit-transform",a.transitionType="webkitTransition",void 0===b.perspectiveProperty&&void 0===b.webkitPerspective&&(a.animType=!1)),void 0!==b.msTransform&&(a.animType="msTransform",a.transformType="-ms-transform",a.transitionType="msTransition",void 0===b.msTransform&&(a.animType=!1)),void 0!==b.transform&&a.animType!==!1&&(a.animType="transform",a.transformType="transform",a.transitionType="transition"),a.transformsEnabled=null!==a.animType&&a.animType!==!1},b.prototype.setSlideClasses=function(a){var c,d,e,f,b=this;d=b.$slider.find(".slick-slide").removeClass("slick-active slick-center slick-current").attr("aria-hidden","true"),b.$slides.eq(a).addClass("slick-current"),b.options.centerMode===!0?(c=Math.floor(b.options.slidesToShow/2),b.options.infinite===!0&&(a>=c&&a<=b.slideCount-1-c?b.$slides.slice(a-c,a+c+1).addClass("slick-active").attr("aria-hidden","false"):(e=b.options.slidesToShow+a,d.slice(e-c+1,e+c+2).addClass("slick-active").attr("aria-hidden","false")),0===a?d.eq(d.length-1-b.options.slidesToShow).addClass("slick-center"):a===b.slideCount-1&&d.eq(b.options.slidesToShow).addClass("slick-center")),b.$slides.eq(a).addClass("slick-center")):a>=0&&a<=b.slideCount-b.options.slidesToShow?b.$slides.slice(a,a+b.options.slidesToShow).addClass("slick-active").attr("aria-hidden","false"):d.length<=b.options.slidesToShow?d.addClass("slick-active").attr("aria-hidden","false"):(f=b.slideCount%b.options.slidesToShow,e=b.options.infinite===!0?b.options.slidesToShow+a:a,b.options.slidesToShow==b.options.slidesToScroll&&b.slideCount-a<b.options.slidesToShow?d.slice(e-(b.options.slidesToShow-f),e+f).addClass("slick-active").attr("aria-hidden","false"):d.slice(e,e+b.options.slidesToShow).addClass("slick-active").attr("aria-hidden","false")),"ondemand"===b.options.lazyLoad&&b.lazyLoad()},b.prototype.setupInfinite=function(){var c,d,e,b=this;if(b.options.fade===!0&&(b.options.centerMode=!1),b.options.infinite===!0&&b.options.fade===!1&&(d=null,b.slideCount>b.options.slidesToShow)){for(e=b.options.centerMode===!0?b.options.slidesToShow+1:b.options.slidesToShow,c=b.slideCount;c>b.slideCount-e;c-=1)d=c-1,a(b.$slides[d]).clone(!0).attr("id","").attr("data-slick-index",d-b.slideCount).prependTo(b.$slideTrack).addClass("slick-cloned");for(c=0;e>c;c+=1)d=c,a(b.$slides[d]).clone(!0).attr("id","").attr("data-slick-index",d+b.slideCount).appendTo(b.$slideTrack).addClass("slick-cloned");b.$slideTrack.find(".slick-cloned").find("[id]").each(function(){a(this).attr("id","")})}},b.prototype.setPaused=function(a){var b=this;b.options.autoplay===!0&&b.options.pauseOnHover===!0&&(b.paused=a,a?b.autoPlayClear():b.autoPlay())},b.prototype.selectHandler=function(b){var c=this,d=a(b.target).is(".slick-slide")?a(b.target):a(b.target).parents(".slick-slide"),e=parseInt(d.attr("data-slick-index"));return e||(e=0),c.slideCount<=c.options.slidesToShow?(c.setSlideClasses(e),c.asNavFor(e),void 0):(c.slideHandler(e),void 0)},b.prototype.slideHandler=function(a,b,c){var d,e,f,g,h=null,i=this;return b=b||!1,i.animating===!0&&i.options.waitForAnimate===!0||i.options.fade===!0&&i.currentSlide===a||i.slideCount<=i.options.slidesToShow?void 0:(b===!1&&i.asNavFor(a),d=a,h=i.getLeft(d),g=i.getLeft(i.currentSlide),i.currentLeft=null===i.swipeLeft?g:i.swipeLeft,i.options.infinite===!1&&i.options.centerMode===!1&&(0>a||a>i.getDotCount()*i.options.slidesToScroll)?(i.options.fade===!1&&(d=i.currentSlide,c!==!0?i.animateSlide(g,function(){i.postSlide(d)}):i.postSlide(d)),void 0):i.options.infinite===!1&&i.options.centerMode===!0&&(0>a||a>i.slideCount-i.options.slidesToScroll)?(i.options.fade===!1&&(d=i.currentSlide,c!==!0?i.animateSlide(g,function(){i.postSlide(d)}):i.postSlide(d)),void 0):(i.options.autoplay===!0&&clearInterval(i.autoPlayTimer),e=0>d?0!==i.slideCount%i.options.slidesToScroll?i.slideCount-i.slideCount%i.options.slidesToScroll:i.slideCount+d:d>=i.slideCount?0!==i.slideCount%i.options.slidesToScroll?0:d-i.slideCount:d,i.animating=!0,i.$slider.trigger("beforeChange",[i,i.currentSlide,e]),f=i.currentSlide,i.currentSlide=e,i.setSlideClasses(i.currentSlide),i.updateDots(),i.updateArrows(),i.options.fade===!0?(c!==!0?(i.fadeSlideOut(f),i.fadeSlide(e,function(){i.postSlide(e)
})):i.postSlide(e),i.animateHeight(),void 0):(c!==!0?i.animateSlide(h,function(){i.postSlide(e)}):i.postSlide(e),void 0)))},b.prototype.startLoad=function(){var a=this;a.options.arrows===!0&&a.slideCount>a.options.slidesToShow&&(a.$prevArrow.hide(),a.$nextArrow.hide()),a.options.dots===!0&&a.slideCount>a.options.slidesToShow&&a.$dots.hide(),a.$slider.addClass("slick-loading")},b.prototype.swipeDirection=function(){var a,b,c,d,e=this;return a=e.touchObject.startX-e.touchObject.curX,b=e.touchObject.startY-e.touchObject.curY,c=Math.atan2(b,a),d=Math.round(180*c/Math.PI),0>d&&(d=360-Math.abs(d)),45>=d&&d>=0?e.options.rtl===!1?"left":"right":360>=d&&d>=315?e.options.rtl===!1?"left":"right":d>=135&&225>=d?e.options.rtl===!1?"right":"left":e.options.verticalSwiping===!0?d>=35&&135>=d?"left":"right":"vertical"},b.prototype.swipeEnd=function(){var c,b=this;if(b.dragging=!1,b.shouldClick=b.touchObject.swipeLength>10?!1:!0,void 0===b.touchObject.curX)return!1;if(b.touchObject.edgeHit===!0&&b.$slider.trigger("edge",[b,b.swipeDirection()]),b.touchObject.swipeLength>=b.touchObject.minSwipe)switch(b.swipeDirection()){case"left":c=b.options.swipeToSlide?b.checkNavigable(b.currentSlide+b.getSlideCount()):b.currentSlide+b.getSlideCount(),b.slideHandler(c),b.currentDirection=0,b.touchObject={},b.$slider.trigger("swipe",[b,"left"]);break;case"right":c=b.options.swipeToSlide?b.checkNavigable(b.currentSlide-b.getSlideCount()):b.currentSlide-b.getSlideCount(),b.slideHandler(c),b.currentDirection=1,b.touchObject={},b.$slider.trigger("swipe",[b,"right"])}else b.touchObject.startX!==b.touchObject.curX&&(b.slideHandler(b.currentSlide),b.touchObject={})},b.prototype.swipeHandler=function(a){var b=this;if(!(b.options.swipe===!1||"ontouchend"in document&&b.options.swipe===!1||b.options.draggable===!1&&-1!==a.type.indexOf("mouse")))switch(b.touchObject.fingerCount=a.originalEvent&&void 0!==a.originalEvent.touches?a.originalEvent.touches.length:1,b.touchObject.minSwipe=b.listWidth/b.options.touchThreshold,b.options.verticalSwiping===!0&&(b.touchObject.minSwipe=b.listHeight/b.options.touchThreshold),a.data.action){case"start":b.swipeStart(a);break;case"move":b.swipeMove(a);break;case"end":b.swipeEnd(a)}},b.prototype.swipeMove=function(a){var d,e,f,g,h,b=this;return h=void 0!==a.originalEvent?a.originalEvent.touches:null,!b.dragging||h&&1!==h.length?!1:(d=b.getLeft(b.currentSlide),b.touchObject.curX=void 0!==h?h[0].pageX:a.clientX,b.touchObject.curY=void 0!==h?h[0].pageY:a.clientY,b.touchObject.swipeLength=Math.round(Math.sqrt(Math.pow(b.touchObject.curX-b.touchObject.startX,2))),b.options.verticalSwiping===!0&&(b.touchObject.swipeLength=Math.round(Math.sqrt(Math.pow(b.touchObject.curY-b.touchObject.startY,2)))),e=b.swipeDirection(),"vertical"!==e?(void 0!==a.originalEvent&&b.touchObject.swipeLength>4&&a.preventDefault(),g=(b.options.rtl===!1?1:-1)*(b.touchObject.curX>b.touchObject.startX?1:-1),b.options.verticalSwiping===!0&&(g=b.touchObject.curY>b.touchObject.startY?1:-1),f=b.touchObject.swipeLength,b.touchObject.edgeHit=!1,b.options.infinite===!1&&(0===b.currentSlide&&"right"===e||b.currentSlide>=b.getDotCount()&&"left"===e)&&(f=b.touchObject.swipeLength*b.options.edgeFriction,b.touchObject.edgeHit=!0),b.swipeLeft=b.options.vertical===!1?d+f*g:d+f*(b.$list.height()/b.listWidth)*g,b.options.verticalSwiping===!0&&(b.swipeLeft=d+f*g),b.options.fade===!0||b.options.touchMove===!1?!1:b.animating===!0?(b.swipeLeft=null,!1):(b.setCSS(b.swipeLeft),void 0)):void 0)},b.prototype.swipeStart=function(a){var c,b=this;return 1!==b.touchObject.fingerCount||b.slideCount<=b.options.slidesToShow?(b.touchObject={},!1):(void 0!==a.originalEvent&&void 0!==a.originalEvent.touches&&(c=a.originalEvent.touches[0]),b.touchObject.startX=b.touchObject.curX=void 0!==c?c.pageX:a.clientX,b.touchObject.startY=b.touchObject.curY=void 0!==c?c.pageY:a.clientY,b.dragging=!0,void 0)},b.prototype.unfilterSlides=b.prototype.slickUnfilter=function(){var a=this;null!==a.$slidesCache&&(a.unload(),a.$slideTrack.children(this.options.slide).detach(),a.$slidesCache.appendTo(a.$slideTrack),a.reinit())},b.prototype.unload=function(){var b=this;a(".slick-cloned",b.$slider).remove(),b.$dots&&b.$dots.remove(),b.$prevArrow&&b.htmlExpr.test(b.options.prevArrow)&&b.$prevArrow.remove(),b.$nextArrow&&b.htmlExpr.test(b.options.nextArrow)&&b.$nextArrow.remove(),b.$slides.removeClass("slick-slide slick-active slick-visible slick-current").attr("aria-hidden","true").css("width","")},b.prototype.unslick=function(a){var b=this;b.$slider.trigger("unslick",[b,a]),b.destroy()},b.prototype.updateArrows=function(){var b,a=this;b=Math.floor(a.options.slidesToShow/2),a.options.arrows===!0&&a.slideCount>a.options.slidesToShow&&!a.options.infinite&&(a.$prevArrow.removeClass("slick-disabled").attr("aria-disabled","false"),a.$nextArrow.removeClass("slick-disabled").attr("aria-disabled","false"),0===a.currentSlide?(a.$prevArrow.addClass("slick-disabled").attr("aria-disabled","true"),a.$nextArrow.removeClass("slick-disabled").attr("aria-disabled","false")):a.currentSlide>=a.slideCount-a.options.slidesToShow&&a.options.centerMode===!1?(a.$nextArrow.addClass("slick-disabled").attr("aria-disabled","true"),a.$prevArrow.removeClass("slick-disabled").attr("aria-disabled","false")):a.currentSlide>=a.slideCount-1&&a.options.centerMode===!0&&(a.$nextArrow.addClass("slick-disabled").attr("aria-disabled","true"),a.$prevArrow.removeClass("slick-disabled").attr("aria-disabled","false")))},b.prototype.updateDots=function(){var a=this;null!==a.$dots&&(a.$dots.find("li").removeClass("slick-active").attr("aria-hidden","true"),a.$dots.find("li").eq(Math.floor(a.currentSlide/a.options.slidesToScroll)).addClass("slick-active").attr("aria-hidden","false"))},b.prototype.visibility=function(){var a=this;document[a.hidden]?(a.paused=!0,a.autoPlayClear()):a.options.autoplay===!0&&(a.paused=!1,a.autoPlay())},b.prototype.initADA=function(){var b=this;b.$slides.add(b.$slideTrack.find(".slick-cloned")).attr({"aria-hidden":"true",tabindex:"-1"}).find("a, input, button, select").attr({tabindex:"-1"}),b.$slideTrack.attr("role","listbox"),b.$slides.not(b.$slideTrack.find(".slick-cloned")).each(function(c){a(this).attr({role:"option","aria-describedby":"slick-slide"+b.instanceUid+c})}),null!==b.$dots&&b.$dots.attr("role","tablist").find("li").each(function(c){a(this).attr({role:"presentation","aria-selected":"false","aria-controls":"navigation"+b.instanceUid+c,id:"slick-slide"+b.instanceUid+c})}).first().attr("aria-selected","true").end().find("button").attr("role","button").end().closest("div").attr("role","toolbar"),b.activateADA()},b.prototype.activateADA=function(){var a=this,b=a.$slider.find("*").is(":focus");a.$slideTrack.find(".slick-active").attr({"aria-hidden":"false",tabindex:"0"}).find("a, input, button, select").attr({tabindex:"0"}),b&&a.$slideTrack.find(".slick-active").focus()},b.prototype.focusHandler=function(){var b=this;b.$slider.on("focus.slick blur.slick","*",function(c){c.stopImmediatePropagation();var d=a(this);setTimeout(function(){b.isPlay&&(d.is(":focus")?(b.autoPlayClear(),b.paused=!0):(b.paused=!1,b.autoPlay()))},0)})},a.fn.slick=function(){var g,a=this,c=arguments[0],d=Array.prototype.slice.call(arguments,1),e=a.length,f=0;for(f;e>f;f++)if("object"==typeof c||"undefined"==typeof c?a[f].slick=new b(a[f],c):g=a[f].slick[c].apply(a[f].slick,d),"undefined"!=typeof g)return g;return a}});
/*!
 * jQuery Cookie Plugin v1.4.1
 * https://github.com/carhartl/jquery-cookie
 *
 * Copyright 2013 Klaus Hartl
 * Released under the MIT license
 */
(function (factory) {
	if (typeof define === 'function' && define.amd) {
		// AMD
		define(['jquery'], factory);
	} else if (typeof exports === 'object') {
		// CommonJS
		factory(require('jquery'));
	} else {
		// Browser globals
		factory(jQuery);
	}
}(function ($) {

	var pluses = /\+/g;

	function encode(s) {
		return config.raw ? s : encodeURIComponent(s);
	}

	function decode(s) {
		return config.raw ? s : decodeURIComponent(s);
	}

	function stringifyCookieValue(value) {
		return encode(config.json ? JSON.stringify(value) : String(value));
	}

	function parseCookieValue(s) {
		if (s.indexOf('"') === 0) {
			// This is a quoted cookie as according to RFC2068, unescape...
			s = s.slice(1, -1).replace(/\\"/g, '"').replace(/\\\\/g, '\\');
		}

		try {
			// Replace server-side written pluses with spaces.
			// If we can't decode the cookie, ignore it, it's unusable.
			// If we can't parse the cookie, ignore it, it's unusable.
			s = decodeURIComponent(s.replace(pluses, ' '));
			return config.json ? JSON.parse(s) : s;
		} catch(e) {}
	}

	function read(s, converter) {
		var value = config.raw ? s : parseCookieValue(s);
		return $.isFunction(converter) ? converter(value) : value;
	}

	var config = $.cookie = function (key, value, options) {

		// Write

		if (value !== undefined && !$.isFunction(value)) {
			options = $.extend({}, config.defaults, options);

			if (typeof options.expires === 'number') {
				var days = options.expires, t = options.expires = new Date();
				t.setTime(+t + days * 864e+5);
			}

			return (document.cookie = [
				encode(key), '=', stringifyCookieValue(value),
				options.expires ? '; expires=' + options.expires.toUTCString() : '', // use expires attribute, max-age is not supported by IE
				options.path    ? '; path=' + options.path : '',
				options.domain  ? '; domain=' + options.domain : '',
				options.secure  ? '; secure' : ''
			].join(''));
		}

		// Read

		var result = key ? undefined : {};

		// To prevent the for loop in the first place assign an empty array
		// in case there are no cookies at all. Also prevents odd result when
		// calling $.cookie().
		var cookies = document.cookie ? document.cookie.split('; ') : [];

		for (var i = 0, l = cookies.length; i < l; i++) {
			var parts = cookies[i].split('=');
			var name = decode(parts.shift());
			var cookie = parts.join('=');

			if (key && key === name) {
				// If second argument (value) is a function it's a converter...
				result = read(cookie, value);
				break;
			}

			// Prevent storing a cookie that we couldn't decode.
			if (!key && (cookie = read(cookie)) !== undefined) {
				result[name] = cookie;
			}
		}

		return result;
	};

	config.defaults = {};

	$.removeCookie = function (key, options) {
		if ($.cookie(key) === undefined) {
			return false;
		}

		// Must not alter options, thus extending a fresh object...
		$.cookie(key, '', $.extend({}, options, { expires: -1 }));
		return !$.cookie(key);
	};

}));

/*
 * Viewport - jQuery selectors for finding elements in viewport
 *
 * Copyright (c) 2008-2009 Mika Tuupola
 *
 * Licensed under the MIT license:
 *   http://www.opensource.org/licenses/mit-license.php
 *
 * Project home:
 *  http://www.appelsiini.net/projects/viewport
 *
 */
(function($) {

  var siteHeader = $('#site-header');
  var headerHeight = siteHeader.outerHeight();

  $.belowthefold = function(element, settings) {
    var fold = $(window).height() + $(window).scrollTop();
    return fold <= $(element).offset().top - settings.threshold;
  };

  $.abovethetop = function(element, settings) {
    var top = $(window).scrollTop();
    return top >= $(element).offset().top + $(element).height() - settings.threshold;
  };

  $.rightofscreen = function(element, settings) {
    var fold = $(window).width() + $(window).scrollLeft();
    return fold <= $(element).offset().left - settings.threshold;
  };

  $.leftofscreen = function(element, settings) {
    var left = $(window).scrollLeft();
    return left >= $(element).offset().left + $(element).width() - settings.threshold;
  };

  $.inviewport = function(element, settings) {
    return !$.rightofscreen(element, settings) && !$.leftofscreen(element, settings) && !$.belowthefold(element, settings) && !$.abovethetop(element, settings);
  };

  $.extend($.expr[':'], {
    "below-the-fold": function(a, i, m) {
      return $.belowthefold(a, {threshold : 0});
    },
    "above-the-top": function(a, i, m) {
      return $.abovethetop(a, {threshold : 0});
    },
    "left-of-screen": function(a, i, m) {
      return $.leftofscreen(a, {threshold : 0});
    },
    "right-of-screen": function(a, i, m) {
      return $.rightofscreen(a, {threshold : 0});
    },
    "in-viewport": function(a, i, m) {
      return $.inviewport(a, {threshold : headerHeight});
    }
  });


})(jQuery);

(function($)
{

  $(function()
  {
    var cookie = $.cookie('cookie-disclaimer');

    if(cookie != '1')
    {
      $('.cookie-ban-wrapper').addClass('visible');
      $('body').addClass('cookied');

      $('.cookie-ban-wrapper a.close').on('click', function()
      {
        $('.cookie-ban-wrapper').removeClass('visible');
        $('body').removeClass('cookied');

        $.cookie('cookie-disclaimer', '1', {expires: 7});
        return false;
      });
    }

  });

})(jQuery);


var gaEventLabels = {

  // button - click - nav
  button_click_nav_logo : {
    en: 'nav - logo',
    fr: 'menu logo',
    de: 'nav - Logo'
  },
  button_click_nav_actifry_smart : {
    en: 'nav - tab 1 - actifry smart',
    fr: 'menu actifry smart',
    de: 'nav - tab 1 - Actifry Smart'
  },
  button_click_nav_application : {
    en: 'nav - tab 2 - application',
    fr: 'menu application',
    de: 'nav - tab 2 - App'
  },
  button_click_nav_recipes : {
    en: 'nav tab 3 - recipes',
    fr: 'menu recettes',
    de: 'nav - tab 3 - Rezepte'
  },
  button_click_nav_reviews : {
    en: 'nav tab 4 - reviews',
    fr: 'menu avis',
    de: 'nav - tab 4 - Bewertungen'
  },
  button_click_nav_contest : {
    en: 'nav tab 5 - contest',
    fr: 'menu jeu concours',
    de: 'nav - tab 5 - Gewinnspiel'
  },
  button_click_nav_where_to_buy : {
    en: 'nav tab 6 - where to buy',
    fr: 'menu où acheter',
    de: 'nav - tab 6 - Wo erhältlich?'
  },

  // anchor - scroll
  anchor_scroll_home : {
    en: 'anchor 1 - home',
    fr: 'home',
    de: 'anchor 1 - Home'
  },
  anchor_scroll_instore_video : {
    en: 'anchor 2 - instore video',
    fr: 'video-instore',
    de: 'anchor 2 - Instore Video'
  },
  anchor_scroll_benefits : {
    en: 'anchor 3 - benefits',
    fr: 'bénéfices',
    de: 'anchor 3 - Produktvorteile'
  },
  anchor_scroll_benefits_videos : {
    en: 'anchor 4 - benefits videos',
    fr: 'videos-bénéfices 25% page vue',
    de: 'anchor 4 - Darstellung der Produktvorteile'
  },
  anchor_scroll_design : {
    en: 'anchor 5 - design',
    fr: 'design',
    de: 'anchor 5 - Design'
  },
  anchor_scroll_technology : {
    en: 'anchor 6 - technology',
    fr: 'technologie',
    de: 'anchor 6 - Technologie'
  },
  anchor_scroll_application : {
    en: 'anchor 7 - application',
    fr: 'application  50% page vue',
    de: 'anchor 7 - App'
  },
  anchor_scroll_compatibility : {
    en: 'anchor 8 - compatibility',
    fr: 'compatibilité',
    de: 'anchor 8 - Kompatibilität'
  },
  anchor_scroll_recipes : {
    en: 'anchor 9 - recipes',
    fr: 'recettes',
    de: 'anchor 9 - Rezepte'
  },
  anchor_scroll_reviews : {
    en: 'anchor 10 - reviews',
    fr: 'avis 75% page vue',
    de: 'anchor 10 - Bewertungen'
  },
  anchor_scroll_news : {
    en: 'anchor 11 - news',
    fr: 'actualités',
    de: 'anchor 11 - News'
  },
  anchor_scroll_contest : {
    en: 'anchor 12 - contest',
    fr: 'jeu-concours',
    de: 'anchor 12 - Gewinnspiel'
  },
  anchor_scroll_where_to_buy : {
    en: 'anchor 13 - where to buy',
    fr: 'où-acheter 100% page vue',
    de: 'anchor 13 - Wo erhältlich?'
  },

  // button - click - home
  button_click_home_check_compatibility: {
    en: 'home - push check compatibility',
    fr: 'Vérifier Compatibilité',
    de: 'home - Kompatibilität überprüfen'
  },
  button_click_home_contest : {
    en: 'home - push contest',
    fr: 'Participation jeu concours',
    de: 'home - Wettbewerb'
  },

  // button - click - share
  button_click_share_facebook: {
    en: 'share on Facebook',
    fr: 'Partage Facebook',
    de: 'Auf Facebook teilen'
  },
  button_click_share_twitter: {
    en: 'share on Twitter',
    fr: 'Partage Twitter',
    de: 'Auf Twitter teilen'
  },

  // video - play - instore
  video_play_instore: {
    en: 'video - instore',
    fr: 'vidéo instore',
    de: 'Instore Video'
  },
  video_play_benefit_smart_cooking: {
    en: 'video - benefit - smart cooking',
    fr: 'vidéo cuisson intelligente',
    de: 'Produktvorteile - Smartes Kochen'
  },
  video_play_benefit_hands_free_cooking: {
    en: 'video - benefit - hands free cooking',
    fr: 'vidéo cuisson sans contrôle',
    de: 'Produktvorteile - Kochen ohne Danebenstehen'
  },
  video_play_benefit_healthy_and_tasty: {
    en: 'video - benefit - healthy and tasty',
    fr: 'vidéo bon & sain',
    de: 'Produktvorteile - Gesund und Lecker'
  },
  video_play_recipe_chicken_drumsticks: {
    en: 'video - recipe - chicken drumsticks and small potatoes',
    fr: 'vidéo pilons poulet',
    de: 'Rezeptvideo - Hähnchenschenkel und kleine Kartoffeln'
  },
  video_play_recipe_breaded_chicken: {
    en: 'video - recipe - breaded chicken breasts',
    fr: 'vidéo escalope panée',
    de: 'Rezeptvideo - Panierte Hähnchenbrustfilets'
  },
  video_play_recipe_turkey_peppers: {
    en: 'video - recipe - turkey with three peppers',
    fr: 'vidéo dinde poivrons',
    de: 'Rezeptvideo - Putenfilet mit 3 Paprikasorten'
  },
  video_play_how_to_use: {
    en: 'video - apple - how to use actifry smart',
    fr: 'vidéo comment ça marche?',
    de: 'Apple Video - Wie funktioniert Meine Actifry?'
  },

  // btn - click - download
  button_click_download_app_store: {
    en: 'download app - App Store',
    fr: 'Téléchargez sur Appstore',
    de: 'App herunterladen - App Store'
  },
  button_click_download_google_play: {
    en: 'download app - Google Play',
    fr: 'Téléchargez sur Google Play',
    de: 'App herunterladen - Google Play'
  },

  // button - click - social
  button_click_social_facebook: {
    en: 'social media - find us on Facebook',
    fr: 'Follow Facebook',
    de: 'Social Media - Besuchen Sie uns auf Facebook'
  },
  button_click_social_twitter: {
    en: 'social media - follow us on Twitter',
    fr: 'Follow Twitter',
    de: 'Social Media - Besuchen Sie uns auf Twitter'
  },

  // button - click - review
  button_click_reviews_more: {
    en: 'reviews - see more reviews',
    fr: 'Plus d\'avis',
    de: 'Bewertungen - Lesen Sie mehr Bewertungen'
  },

  // button - click - contest
  button_click_contest_participate: {
    en: 'contest - participate',
    fr: 'Participation jeu concours',
    de: 'Wettbewerb - Teilnehmen'
  },
  button_click_contest_regulations: {
    en: 'contest - see regulations',
    fr: 'Modalités jeu concours',
    de: 'Wettbewerb - Lesen Sie die Bestimmungen'
  },

  // button - click - where
  button_click_where_buy_online: {
    en: 'where to buy - buy online',
    fr: 'Acheter en ligne',
    de: 'Wo erhältlich? - Kaufen Sie online'
  },
  button_click_where_buy_in_store: {
    en: 'where to buy - buy in store',
    fr: 'Trouver un revendeur',
    de: 'Wo erhältlich? - Kaufen Sie im Handel'
  },
  button_click_where_buy_range: {
    en: 'where to buy - discover the rest of the range',
    fr: 'Découvrir la gamme Actifry',
    de: 'Wo erhältlich? - Entdecken Sie den Rest des Sortiments'
  },
  button_click_where_buy_download_guide: {
    en: 'where to buy - download the user guide',
    fr: 'Télécharger le mode d\'emploi',
    de: 'Wo erhältlich? - Laden Sie das Benutzerhandbuch herunter'
  },
  button_click_where_buy_accessories: {
    en: 'where to buy - accessories and spare parts',
    fr: 'Boutique Accessoires',
    de: 'Wo erhältlich? - Zubehör und Ersatzteile'
  },
  // DISTRIBUTORS
  button_click_darty: {
    en: 'Darty',
    fr: 'Darty',
    de: 'Darty'
  },
  button_click_boulanger: {
    en: 'Boulanger',
    fr: 'Boulanger',
    de: 'Boulanger'
  }

};


// Tracking
$(function() {

  $("body").on("mousedown", ".ga-tracking", function() {
    var e = $(this);
    var label = e.data('label');
    sendGaEvent(label);
    return false;

  });

});

function sendGaEvent(label) {

  var lang = $(".desktop").attr('lang');
  if(gaEventLabels[label] == undefined || gaEventLabels[label][lang] == undefined) {
    return;
  }
  var localLabel = gaEventLabels[label][lang];
  var elements = label.split('_');
  if(typeof(ga) == 'function') {
    ga('send', 'event', elements[0], elements[1], localLabel);
  } else {
    console.log('trigger event', elements[0], elements[1], localLabel);
  }


}

function appendInPopup(content) {

  var overlay = $('<div class="overlay"></div>');
  overlay.appendTo('.actifry-content').fadeIn(300);

  if((content).hasClass('video-autoplay')) {
    videoCreateIframe(content.find('.video'));
  }

  setTimeout(function(){
    content.appendTo(overlay).fadeIn(600);
  }, 300);


}

$(function()
{
  'use strict';


  $('.popup-link').mousedown(function() {
    var e = $(this);
    var target = e.data('target');
    appendInPopup($('.popup.' + target).eq(0).clone());
  });

  $('.actifry-content').on('click', '.popup .close', function() {
    $(this).closest('.overlay').fadeOut(400, function() {
      $(this).remove();
    });
    return false;
  });
});

$(function() {
  'use strict';

  var windowWidth = 1350;
  if(isMobile.phone){
    windowWidth = 350;
  }

  var popupIframe = $('.popup iframe');
  if (popupIframe.length != 0) {
    popupIframe.each(function () {
      var e = $(this);
      e.attr('src', e.attr('src') + '?w=' + windowWidth);
      if(isMobile.phone) {
        e.attr('height', 50);
      }
    });
  }


});
$(function()
{
  'use strict';

  var slideToshow    = 1;
  var slidesToScroll = 1;


  var container = $('.slideshow').each(function()
  {
    var e = $(this);

    if(e.is('.slide-3') && !isMobile.phone)  {
      slideToshow = 3;
    } else {
      slideToshow = 1;    
    }

    e.slick(
    {
      infinite: true,
      slide: '.slide',
      slidesToShow: slideToshow,
      slidesToScroll: slidesToScroll,
      draggable: true,
      arrows: false,
      autoplaySpeed: 8000,
      autoplay: false,
      dots: false,
      speed: 500,
      swipe: true
    });

    if(!e.find('.slide')[slideToshow])
    {
      e.find('.prev, .next').hide();
    }
    e.find('.prev').on('click', function()
    {
      e.slick('slickPrev');
      return false;
    });
    e.find('.next').on('click', function()
    {
      e.slick('slickNext');
      return false;
    });

    if(e.parent().find('.slideshow-controls')[0]) {
      e.parent().find('.slideshow-controls li.col a').click(function() {
        var e = $(this);
        var index = e.parent().index();

        e.parent().parent().find('li.col').removeClass('active');
        e.parent().addClass('active');

        container.slick('slickGoTo', index);
      });
    }

    // remove video and reset thumbnail state on change
    e.on('beforeChange', function(event, slick, currentSlide, nextSlide){
      e.find('.slide').removeClass('playing').find('.video-iframe').remove();

      // if slideshow control we manage active states
      if(e.parent().find('.slideshow-controls')[0]) {
        e.parent().find('.slideshow-controls li.col a')
          .removeClass('active')
          .eq(nextSlide)
          .addClass('active');
      }

    });


  });


  // Mobile //////////////////////////////////////////
  if(!isMobile.phone) return;

  var containerMobile = $('.slideshow-mobile').each(function(){
    var e = $(this);  

    e.slick({
      slide: '.slide',
      slidesToShow: 1,
      slidesToScroll: 1,
      dots: true,
      swipe: true
    });

  });

});
var actiFb, actiTw, actiBasePath, actiTwitterTexts, actiTwitterNoValues = false;
function socialLinkUpdate(sectionId, anchor) {
  if(actiFb == undefined) {
    actiFb = $('.socials .fb');
    actiTw = $('.socials .tw');
    actiBasePath = window.location.origin;
    if($('.social-value')[0])
      actiTwitterTexts = jQuery.parseJSON($('.social-value').text());
    else
      actiTwitterNoValues = true;
  }

  var twitterText;
  if (actiTwitterNoValues) {
    twitterText = "Actifry";
  } else {
    twitterText = actiTwitterTexts["section_" + sectionId];
  }
  var actiUrl = actiBasePath + "?t=" + sectionId + "#_" + anchor;
  actiFb.attr('href', 'https://www.facebook.com/sharer/sharer.php?u=' + encodeURIComponent(actiUrl));
  actiTw.attr('href', 'https://twitter.com/share?url=' + encodeURIComponent(actiUrl) + '&text=' + encodeURI(twitterText));
}


function videoCreateIframe(videoWrapper) {
  var videoFrame = '<iframe class="video-iframe" src="https://www.youtube.com/embed/%VIDEOID%?autoplay=1&modestbranding=1" frameborder="0" allowfullscreen></iframe>';
  if(videoWrapper.hasClass('playing'))
    return false;

  if(videoWrapper.data('youtube-id') != undefined)
    videoWrapper.append(videoFrame.replace('%VIDEOID%', videoWrapper.data('youtube-id'))).addClass('playing');
}

$(function()
{
  'use strict';

  $('body').on('click', '.video .play-btn', function() {
    var videoWrapper = $(this).closest('.video');
    videoCreateIframe(videoWrapper);
    return false;
  });


});

if (!window['YT']) {var YT = {loading: 0,loaded: 0};}if (!window['YTConfig']) {var YTConfig = {'host': 'http://www.youtube.com'};}if (!YT.loading) {YT.loading = 1;(function(){var l = [];YT.ready = function(f) {if (YT.loaded) {f();} else {l.push(f);}};window.onYTReady = function() {YT.loaded = 1;for (var i = 0; i < l.length; i++) {try {l[i]();} catch (e) {}}};YT.setConfig = function(c) {for (var k in c) {if (c.hasOwnProperty(k)) {YTConfig[k] = c[k];}}};var a = document.createElement('script');a.type = 'text/javascript';a.id = 'www-widgetapi-script';a.src = 'http:' + '//s.ytimg.com/yts/jsbin/www-widgetapi-vfltoz0n9/www-widgetapi.js';a.async = true;var b = document.getElementsByTagName('script')[0];b.parentNode.insertBefore(a, b);})();}

var playerflux;
var player1;
var player2;
var player3;
var player4;
function onYouTubePlayerAPIReady()
{

  playerflux = new YT.Player('player-flux', {
    height: '480',
    width: '854',
    videoId: 'nmYJsAllGf0',
    playerVars:{
      autoplay:1,
      controls:0,
      modestbranding:1,
      rel:0,
      showinfo:0,
      theme:'light',
      wmode: "opaque"
    },
    events: {
      'onStateChange': onPlayerStateChange
    }
  });


  if($('html').attr('lang') == 'fr') {
    return;
  }


  if(!isMobile.phone)
  {
    player1 = new YT.Player('player-ipad-1', {
      videoId: 'fPTZIzpi238',
      playerVars:{
        autoplay:0,
        controls:0,
        modestbranding:1,
        rel:0,
        showinfo:0,
        theme:'light'
      },
      events: {
        'onReady': onPlayer1Ready,
        'onStateChange': onPlayerStateChange
      }
    });
    player2 = new YT.Player('player-ipad-2', {
      videoId: 'QI1KBD7CiYc',
      playerVars:{
        autoplay:0,
        controls:0,
        modestbranding:1,
        rel:0,
        showinfo:0,
        theme:'light'
      },
      events: {
        'onReady': onPlayer2Ready,
        'onStateChange': onPlayerStateChange
      }
    });
    player3 = new YT.Player('player-ipad-3', {
      videoId: 'GW5bfJJX0E8',
      playerVars:{
        autoplay:0,
        controls:0,
        modestbranding:1,
        rel:0,
        showinfo:0,
        theme:'light'
      },
      events: {
        'onReady': onPlayer3Ready,
        'onStateChange': onPlayerStateChange
      }
    });
    player4 = new YT.Player('player-ipad-4', {
      videoId: 'kpIcb7tZRZA',
      playerVars:{
        autoplay:0,
        controls:0,
        modestbranding:1,
        rel:0,
        showinfo:0,
        theme:'light'
      },
      events: {
        'onReady': onPlayer4Ready,
        'onStateChange': onPlayerStateChange
      }
    });
  }
}

function onPlayer1Ready(event)
{
  var p = event.target;

  p.playVideo();
  p.pauseVideo();
  $(function()
  {
    $('.section.application .slideshow-mobile > .col-1').on('mouseenter', function()
    {
      p.seekTo(0);
      p.playVideo();

    }).on('mouseleave', function()
    {
      p.pauseVideo();
    });
  });
}
function onPlayer2Ready(event)
{
  var p = event.target;

  p.playVideo();
  p.pauseVideo();
  $(function()
  {
    $('.section.application .slideshow-mobile > .col-2').on('mouseenter', function()
    {
      p.seekTo(0);
      p.playVideo();

    }).on('mouseleave', function()
    {
      p.pauseVideo();
    });
  });
}
function onPlayer3Ready(event)
{
  var p = event.target;

  p.playVideo();
  p.pauseVideo();
  $(function()
  {
    $('.section.application .slideshow-mobile > .col-3').on('mouseenter', function()
    {
      p.seekTo(0);
      p.playVideo();

    }).on('mouseleave', function()
    {
      p.pauseVideo();
    });
  });
}
function onPlayer4Ready(event)
{
  var p = event.target;

  p.playVideo();
  p.pauseVideo();
  $(function()
  {
    $('.section.application .slideshow-mobile > .col-4').on('mouseenter', function()
    {
      p.seekTo(0);
      p.playVideo();

    }).on('mouseleave', function()
    {
      p.pauseVideo();
    });
  });
}

function onPlayerStateChange(event) {
  if (event.data == YT.PlayerState.ENDED) {
    event.target.playVideo();
  }
}

var device = 'desktop';

if(isMobile.phone){
  device = 'mobile';
}
else if(isMobile.tablet){
  device+= ' tablet';
}
// else if(isMobile.tablet){
//   device = 'tablet';
// }
document.querySelectorAll('html')[0].className = device;




function isIE(){
  var myNav = navigator.userAgent.toLowerCase();
  return (myNav.indexOf('msie') != -1) ? parseInt(myNav.split('msie')[1]) : false;
}



$(function()
{
  'use strict';
  
  var ie = isIE();

  if(ie && ie <= 11) {
    $('html').addClass('ie ie'+ie);
  }


  // Mobile //////////////////////////////////////////
  if(!isMobile.phone) return;

});



$(function()
{
  'use strict';



  function getLinkAnchor(url) {
    return url.substring(url.indexOf("#")+1);
  }

  var site_header = $('#site-header');

  var headerHeight = site_header.outerHeight();

  var navLinks = $('div.site-nav a');
  navLinks.click(function()
  {
    var e = $(this);
    var hash = getLinkAnchor(e.attr('href'));

    $('#' + hash).animatescroll({
      padding: headerHeight
    });

    return false;

  });

  // Get initial anchor in url
  function getInitialHash() {
    var hash = document.location.hash.replace('#_', '');

    if(hash != '') {
    setTimeout(function()
    {
        $('#' + hash).animatescroll({
          padding: site_header.outerHeight()
        });

    }, 500);
    }
  }
  getInitialHash();


  if(!isMobile.phone || site_header.hasClass('header-fixed-mobile'))
  {
    var topheight = site_header.offset().top;

    var headerHeight = site_header.outerHeight();
    var cookieBanHeight = $('.cookie-ban-wrapper').outerHeight();

    var i = 0;
    var timerheight = setInterval(function()
    {
      topheight = site_header.offset().top;
      headerHeight = site_header.outerHeight();
      cookieBanHeight = $('#cookie_container').outerHeight();

      if(i>12) {
        clearInterval(timerheight);
      }
      i++;
    },280);


    $('body').on('mouseup', '.cookiesmessage .close', function()
    {
      setTimeout(function()
      {
        topheight = site_header.offset().top;
        headerHeight = site_header.outerHeight();
        cookieBanHeight = $('#cookie_container').outerHeight();
      }, 500);
    });

    var W = $(window);
    var B = $('body');


    W.scroll($.throttle(100, function(e)
    {
      var pos = W.scrollTop();

      if(pos > (headerHeight + cookieBanHeight))
      {
        B.addClass('actifry-menu-scrolled');
      }
      else
      {
        B.removeClass('actifry-menu-scrolled');
      }

    })).scroll();
    


  }


  $('#footer .infos a').click(function() {
    $('#expandInfosBlock').toggleClass('visible');
  });


  // Mobile //////////////////////////////////////////
  if(!isMobile.phone) return;

  // Menu
  $('#mobile-nav-toggle').on('click', function(){
    $(this).toggleClass('active');
    $('.site-nav').toggleClass('show');
    return false;
  });

  $('.site-nav a').on('click', function(){
    $('#mobile-nav-toggle').click();
  });

});
$(function()
{
  'use strict';

  function getLinkAnchor(url) {
    return url.substring(url.indexOf("#")+1);
  }
  var navLinks = $('div.site-nav a');
  function updateActiveMenuItem(currentAnchor) {
    navLinks.each(function() {
      var e = $(this);
      var hash = getLinkAnchor(e.attr('href'));
      if(hash == currentAnchor) {
        navLinks.removeClass('active');
        e.addClass('active');
      }
    });
  }

  $('.section').on('fadeInRender', function(event) {
    var e = $(this);
    e.addClass('visible');
    if(!e.find('.col')[0]) {return;}

    var length = e.find('.col').length;
    var i = 0;
    var timer = setInterval(function(){
      e.find('.col').eq(i).addClass('visible');
      if(i >= length) {
        clearInterval(timer);
      }
      i++
    }, 300);

  });

  var previousTargetGa = '';
  function scrollGaEvent(classes) {
    classes = classes.replace('visible', '').replace('section', '');
    var re = new RegExp('-', 'g');
    var sectionName = $.trim(classes).replace(re, '_');
    var target = 'anchor_scroll_' + sectionName;
    if(previousTargetGa == target)
      return;

    previousTargetGa = target;
    sendGaEvent(target);
  }

  var W = $(window);

  var lastAnchor;
  var firstScroll = true;
  W.scroll($.throttle(180, function(e)
  {

    // in-viewport sections.
    var sections = $('.section:in-viewport');
    var mainSection = $(sections[0]);



    // manage menu item active states.
    var anchor = mainSection.attr('id');
    if(anchor == lastAnchor) {
      return
    }
    scrollGaEvent(mainSection.attr('class'));

    if(!firstScroll) {
      lastAnchor = anchor;
      document.location.hash = '#_' + anchor;
    } else {
      firstScroll = false;
    }
    updateActiveMenuItem(anchor);
    socialLinkUpdate(mainSection.data('section-id'), anchor);

    // Specific case for autoplay video section, automatically play video.
    if(mainSection.hasClass('autoplay-video-section')
    || (sections[1] && $(sections[1]).hasClass('autoplay-video-section'))) {

      $('.autoplay-video-section .autoplay-video .play-btn').click();
    }


    // Manage initial fadeIn
    setTimeout(function() {
      sections.not('.visible').trigger('fadeInRender');
    }, 350);

  })).scroll();



  // Mobile //////////////////////////////////////////
  if(!isMobile.phone) return;

  // Scroll top
  var scrollPosition = 0,
  scrollTop = $('.scroll-top');

  scrollTop.on('click', function(){
    scroll(0, 0);
    return false;
  });

  W.scroll($.throttle(200, function(e)
  {
    scrollPosition= $(window).scrollTop();
    (scrollPosition > 545) ? scrollTop.fadeIn(200) : scrollTop.fadeOut(200);
  }));

});
$(function()
{
  'use strict';

  if(!isMobile.phone)
  {
    $('.section.application .steps .zoom').on('mouseenter', function()
    {
      $(this).addClass('active');

    }).on('mouseleave', function()
    {
      $(this).removeClass('active');
    });
  }

  // Mobile //////////////////////////////////////////
  if(!isMobile.phone) return;

  // Open application video on new tab
  $('.section.application .slideshow-mobile .col').on('click', function(){
    var e = $(this);

    window.open('https://www.youtube.com/embed/' + e.data('youtube-id'), '_blank');
  });

});







$(function()
{
  'use strict';

  var lang = 'en';
  var section = $('.section.contest');

  if(section.data('lang'))
  {
    lang = section.data('lang');
  }


  var quizzStatus = false;
  var quizzUrl = 'http://actifrysmart.seb.fr/jeu/'+lang;
  var device = isMobile.phone ? 'mobile' : 'desktop';

  var iframe = $('<iframe src="'+quizzUrl+'?device='+device+'"  frameborder="0" scrolling="no"></iframe>')
  .appendTo(section.find('.wrapper'));


  // Manage message coming from the iframe
  $(window).on("message", function(e) {
    var data = JSON.parse(e.originalEvent.data);


    // manage google analytics event triggered in iframe
    if(data.ga_event != undefined) {
      sendGaEvent(data.ga_event);
    }


    if(data.quizzHeight != undefined) {
      $('.section.contest iframe').css('height', data.quizzHeight);
    }

    if(data.quizzPopup != undefined) {
      var attributes = {};
      var popupContent;
      var popupWrapper;
      if(data.quizzPopup.video != undefined) {
        popupContent = '' +
          '<div class="video">' +
          ' <iframe class="video-iframe" src="' + data.quizzPopup.video + '"></iframe>' +
          '</div>';
        popupWrapper = '' +
          '<div class="popup quizz-hint">' +
          '<a class="close">Close</a>' +
          popupContent +
          '</div>';
        appendInPopup($(popupWrapper));
      }

      if(data.quizzPopup.image != undefined) {
        popupContent = '' +
          '<div class="image">' +
          ' <img src="' + data.quizzPopup.image + '">' +
          '</div>';
        popupWrapper = '' +
          '<div class="popup popup-wrapper quizz-hint">' +
          '<div class="adaptive-content">' +
          '<a class="close">Close</a>' +
          popupContent +
          '</div>' +
          '</div>';
        appendInPopup($(popupWrapper));
      }

    }
  });

  // try to get cross domain json to know quizz status :

  $.ajaxSetup({
    scriptCharset: "utf-8",
    contentType: "application/json; charset=utf-8"
  });

  $.getJSON(quizzUrl+'/quizz/status', function(data)
  {
    // if active
    if(data.status){

    } else {
      iframe.closest('.section').remove();
    }
  });

});
$(function()
{
  'use strict';

  if(!isMobile.phone) {

    var imgs = {
      0  : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxNDI3OTh8aW1hZ2UvcG5nfGltYWdlcy9oZmIvaGNiLzg4OTYyMTUwODkxODIucG5nfGRmNTIzMWI4NmQwYWQ2MTIxNTJlNWFkNzI2ZjhkMTUyN2JmNDI5NWVmMjU4MTNjYTgwMzA5Y2ZjZTY4ZGQzMjE',
      1  : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxNDAxOTN8aW1hZ2UvcG5nfGltYWdlcy9oNDgvaDcwLzg4OTYyMTUxNTQ3MTgucG5nfGJiOWFiMDRkNjBkNzhjZDNmYTA2M2NjMDE3MzNmZGY4ODg0NmVhYjA3ZDFmYjE5YTdiMmRhYjMzNmZmM2VmNjc',
      2  : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMzk5NzN8aW1hZ2UvcG5nfGltYWdlcy9oZGUvaGJiLzg4OTYyMTUyMjAyNTQucG5nfDljODZiMDQwZWQzNTlmZTE3MWEwMTZmOWM0NjIxZWQxNjViOGJmNmMyMDllN2RiODRjZmVhNWNkMDhhNDIzNGU',
      3  : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMzk2NzR8aW1hZ2UvcG5nfGltYWdlcy9oZWMvaDIzLzg4OTYyMTUyODU3OTAucG5nfDA4YjViZDAzZTMyNTdhOTY4MjU2M2FkYjE2ZjdhMGIyNWU5NjYxNDg3MzM4ODFhZTdlN2ZjMzE2MjQwNzI2NWY',
      4  : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMzcyNjR8aW1hZ2UvcG5nfGltYWdlcy9oNmEvaGIyLzg4OTYyMTUzNTEzMjYucG5nfDM4OGJlOTBkZGI4ZmNkYzc5Nzg0ZmMxYmE2N2U5NGIwZDA5MTBlZWQwYjQ0OGJkOTU2YzMyNDk0MGYyZmE0OGQ',
      5  : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMzU0MDh8aW1hZ2UvcG5nfGltYWdlcy9oMDUvaGMxLzg4OTYyMTU0MTY4NjIucG5nfGE4OGIwODlkN2ZkNmUzODYwZDNhOTQxMGE1NmU1NTI4Nzg1MjA2ZWU1MDkwYjNhYzg4MDE4NDg2ZDExODMxMzU',
      6  : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMzA3ODF8aW1hZ2UvcG5nfGltYWdlcy9oNWQvaDY4Lzg4OTYyMTU0ODIzOTgucG5nfDFiM2QwNDI4ODIzNDdkODMyOTNhMWQzMGJlZWM3ODlmYTZkOThmMzFlNDczYTcyMTY4NDI5OGVhYjVkMzViOTU',
      7  : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMjg4OTd8aW1hZ2UvcG5nfGltYWdlcy9oNDIvaGFkLzg4OTYyMTU1NDc5MzQucG5nfGE3OTY5ZTVjNjBhNjkwNmQ0ODNiNTQ0MjVhYjkzOWQ1ZDNhNWNlYTNhYTJlMzE4ZGYyMGIwMWJjMDJjNTMyNTU',
      8  : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMzA0NjN8aW1hZ2UvcG5nfGltYWdlcy9oZTMvaDdlLzg4OTYyMTU2MTM0NzAucG5nfGFlZTA5M2IwM2FkYzJjMmZhNmMyNzNhYzIyMzliNjhhOWE3NjNkNGRhMzI2OTU5ZTM1NWM2NDM3OGRlM2VmZTM',
      9  : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMzA2MjJ8aW1hZ2UvcG5nfGltYWdlcy9oM2EvaDkyLzg4OTYyMTU2NzkwMDYucG5nfDIyZGNiNGRhN2VlZGRkNTRhNjhlZGQyYzRmYTliZjRiMTI4MGE1NmIzOWVlNmUwYmZlN2QxZmUwOWM4NTBiNDg',
      10 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMjk0MDF8aW1hZ2UvcG5nfGltYWdlcy9oNjQvaGVmLzg4OTYyMTU3NDQ1NDIucG5nfGYwYTEwZTgzMWE3ZDkxODNiMGJlM2I0ZGViYWU0ZTAyMzI1YWY5NjQ4NmNjNGE5YmExNTY5MGMzZjg5NzM4YzA',
      11 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMjA1MjZ8aW1hZ2UvcG5nfGltYWdlcy9oNzIvaDNhLzg4OTYyMTU4MTAwNzgucG5nfGZkNzEzMjc0NTA3OGE0YTk0MzkxMWIwMTUxNGM3MjVmNTBlNWJkNGE5NmFiM2M5ZDUxNjcxYWJlMTUwZjUyNzk',
      12 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMDcyODF8aW1hZ2UvcG5nfGltYWdlcy9oYWQvaDVkLzg4OTYyMTU4NzU2MTQucG5nfGNhMTk1ZTE4MjdiMmVlZDIyNzhlYTkwNWQ5YjRjODcxM2RmYzZjMjM1MzZhZjEzMzE0YTc1OWMwMDc5MTA5NDY',
      13 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMDI3NjZ8aW1hZ2UvcG5nfGltYWdlcy9oNzkvaGNlLzg4OTYyMTU5NDExNTAucG5nfDMwNWY0Zjg5MmNlZmYyZjZlNjJjZDI5NzEwZWE0NTcwMDEzMTQzNWYzNTBhYWQxYjcxMjQyNDM5Y2U3YzY0NjA',
      14 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMDA0NDl8aW1hZ2UvcG5nfGltYWdlcy9oYTUvaDUzLzg4OTYyMTYwMDY2ODYucG5nfDliNzMzZjAzNzQxMmNhMGM5Njk2YWNjMGQ2NTQ3MDhjNzE1YTk4Y2JiNTRhNjc2MzU2ZDg4ZGI3NGI1YWRhYTE',
      15 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3w5NjYxOXxpbWFnZS9wbmd8aW1hZ2VzL2hjMi9oOGIvODg5NjIxNjA3MjIyMi5wbmd8YWFjN2QwY2QzNzdkYThlYjYxOTM4YWUxZmNiZDcyNGIwMjNhYTdjZWE5YjI1NjFhYTU2NzIxOTkwMjQxNGFmOA',
      16 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3w5NjQ1OHxpbWFnZS9wbmd8aW1hZ2VzL2g1ZC9oZTUvODg5NjIxNjEzNzc1OC5wbmd8NWQ1MjEyNzU3OTBjNTc2NjJhNmY4OGRkMTAyOGM1MDJiODdhMjk4MzhkYmE0ODJkNTRjY2E3NjA1ZTA0M2I5NQ',
      17 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMDA1NDZ8aW1hZ2UvcG5nfGltYWdlcy9oODMvaDExLzg4OTYyMTYyMDMyOTQucG5nfDExMTE5ZTdhODk3YWNiZjhlNWE0MmI0Nzc0MDMwMmNiMjU0MjBlYWIzMGZiY2UyM2Q0OGFmZWQwY2RlOWMyMDM',
      18 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMDIzNzd8aW1hZ2UvcG5nfGltYWdlcy9oOWIvaDg2Lzg4OTYyMTYyNjg4MzAucG5nfDQ4MWJlZmQxMTY0NjRiM2JhNGE5MTIwODY2MGE0ZTU3Y2Y3NGM4NmJmN2I5ODY0YmM2MWQxMGNkOWM2NDMxMzY',
      19 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMDQ2Mzd8aW1hZ2UvcG5nfGltYWdlcy9oM2IvaGEzLzg4OTYyMTYzMzQzNjYucG5nfGQzOWEyNGYwYjE3ZmFjYmQxYTkzY2Y4OTZjNzhhOGM4NDE3ZTE1NjcwZDQzNTQ0MjQ5YmNiNTVkMzkwOWEyMjc',
      20 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMDg0MTF8aW1hZ2UvcG5nfGltYWdlcy9oMWMvaDBiLzg4OTYyMTYzOTk5MDIucG5nfDM5ZDVjNDY3OGUzZGQzNGQ4Mzg4MjY2OGI3YTQ1OTI4NDMwZDJiOWY4OWUzOWM5YjZlYjY1NjhhN2I3YTEwZmE',
      21 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMTI3NzF8aW1hZ2UvcG5nfGltYWdlcy9oMGMvaGNiLzg4OTYyMTY0NjU0MzgucG5nfDFhNzI2M2MwYzY2MGVlMjhlNmI3ZjYyMjc3ZGRmYTY2ZWNjYTM5MGY2OWUzMjA5N2YxMzllNTU1Y2MwZWFmMTg',
      22 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMTU1MzZ8aW1hZ2UvcG5nfGltYWdlcy9oYWMvaDRjLzg4OTYyMTY1MzA5NzQucG5nfDcyZmJhYTE1YWI5MTBmNzlmYzMxMmFjN2RjODQ5ZWE0ODNjYjM1MzFiYjk1ZjgwYTBjMzIyZmRiMTA0ZTgyYjI',
      23 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMTgzODJ8aW1hZ2UvcG5nfGltYWdlcy9oMDUvaDM3Lzg4OTYyMTY1OTY1MTAucG5nfGZiMWE1Yzk0MWUwZDg2YTBkMThiNTZjZTkwNzBhYTg5NjI2ODE3ZDgxN2NkOTgyZTE5YmRjYzA2YTVlMmM4YzQ',
      24 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMjE5MzF8aW1hZ2UvcG5nfGltYWdlcy9oZDEvaGYyLzg4OTYyMTY2NjIwNDYucG5nfDBkMWI4ODEwMTc2ZTkxOWY1MjJjNDNiZjMyMmE3Mjc1ZTI5ZWEyZGZlY2RmYTZhMGEwNjE2YmViY2NlYTBhZGY',
      25 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMjI5OTd8aW1hZ2UvcG5nfGltYWdlcy9oNDAvaDY2Lzg4OTYyMTY3Mjc1ODIucG5nfDY4N2ExZmUyOGNmM2UwZTM1NTAzZDA0YjY4MzcyZTE2NzNjMGEzODg0ZThhNDBhNDI2M2YwZWJjZjI3YzE2YWY',
      26 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMjQ4MzV8aW1hZ2UvcG5nfGltYWdlcy9oNzcvaDdiLzg4OTYyMTY3OTMxMTgucG5nfDNiZGI5NDUwOTUxN2ViOWI4NWM1MmQzNzQ3MWQ3MmNiYTFjMjliNTk5NzExNTI2NzUzMDIzYzJkMjlhODJiMzc',
      27 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMjM5MzN8aW1hZ2UvcG5nfGltYWdlcy9oZjgvaGY3Lzg4OTYyMTY4NTg2NTQucG5nfGQzYzExNzdiNzlkNzdhMjhiOTI5ZmE1YWRlOTY4ODA5NDM2MDQ4M2M0M2M3NDIzOGNlNmEwOTc0MjUxOWViNGU',
      28 : 'http://www.tefal.com/medias/?context=bWFzdGVyfGltYWdlc3wxMjQ5NzJ8aW1hZ2UvcG5nfGltYWdlcy9oMWUvaDI0Lzg4OTYyMTY5MjQxOTAucG5nfGFkZTZmMmYwNjU2YjliZDE2NTQyYzIzMmMwZGEzMWM2MDZhN2MzNjEzZThmMWVhYzc0MzY5NDMxZjJiY2U3OTA'
    };



    var threesixty = $('.section.design .threesixty').ThreeSixty(
    {
      totalFrames: 29, // Total no. of image you have for 360 slider
      endFrame: 30, // end frame for the auto spin animation
      currentFrame: 1, // This the start frame for auto spin
      imgList: '.threesixty-images', // selector for image list
      progress: '.spinner', // selector to show the loading progress
      imagePath:'/img/', // path of the image assets
      ext: '.png', // extention for the assets
      height: 520,
      width: 520,
      //filePrefix: 'frame-',
      navigation: false,
      framerate: 18,
      disableSpin: false,
      drag: false,
      imgArray: imgs,
      onReady: function()
      {
        $('.threesixty-slider').fadeIn(200);
      }
    });


    var legends = $('.section.design .legend');
    var legend1 = $('.section.design .legend-1');
    var legend2 = $('.section.design .legend-2');
    var legend3 = $('.section.design .legend-3');

    $(".threesixty-slider input").on("slider:changed", function(event, data)
    {
      threesixty.gotoAndPlay(data.value);

      var text = legend3;

      if(data.value < 9)
      {
        var text = legend1;
      }
      else if(data.value < 24)
      {
        var text = legend2;
      }

      legends.not(text).removeClass('show');
      text.addClass('show');

    });

  }


});
$(function()
{
  'use strict';

  var headerHeight = $('#site-header').outerHeight();

  $('.section.home .button-participate').on('click', function()
  {
    $('.section.contest').animatescroll({
      padding: headerHeight
    });
    return false;
  });

  /*$('.section.home .compatibility .button').on('click', function()
  {
    $('.section.compatibility').animatescroll({
      padding: headerHeight - 30
    });
    return false;
  });*/


  // Mobile //////////////////////////////////////////
  if(!isMobile.phone) return;

  // Adjust home section padding with mobile width

  var baseWidth = 320, basePaddingTop = 0, deviceWidth = 0, paddingTop = 0;

  // Get target Element
  var targetElement = $('.mobile .section.home .aside');

  // Get base padding top
  basePaddingTop = targetElement.css('paddingTop').replace(/[^-\d\.]/g, '');

  // Get device width
  deviceWidth = $(window).width();

  paddingTop = (deviceWidth * basePaddingTop) / baseWidth;

  targetElement.css('paddingTop', paddingTop);

});
$(function()
{
  'use strict';



});







/*$(function()
{
});*/
$(function()
{
  'use strict';



  // Mobile //////////////////////////////////////////
  if(!isMobile.phone) return;

  // Adjust illustration height with mobile width

  var baseWidth = 320, baseHeight = 0, deviceWidth = 0, height = 0;

  // Get target Element
  var targetElement = $('.mobile .section.where-to-buy .illustration');

  // Get base height
  baseHeight = targetElement.css('height').replace(/[^-\d\.]/g, '');  
  
  // Get device width
  deviceWidth = $(window).width();
  
  // Calcul height to set
  height = (deviceWidth * baseHeight) / baseWidth;

  // Set height
  targetElement.css('height', height);

});